/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.network;

import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.network.BufferUtil;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateRateLimit
implements IMessage {
    private BlockPos pos;
    private int rateLimit;

    public PacketUpdateRateLimit() {
    }

    public PacketUpdateRateLimit(BlockPos meterPos, int rateLimit) {
        this.pos = meterPos;
        this.rateLimit = rateLimit;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BufferUtil.readBlockPos(buf);
        this.rateLimit = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        BufferUtil.writeBlockPos(buf, this.pos);
        buf.writeInt(this.rateLimit);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateRateLimit, IMessage> {
        public IMessage onMessage(PacketUpdateRateLimit message, MessageContext ctx) {
            BlockPos pos = message.pos;
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                if (!world.func_175667_e(pos)) {
                    EnergyMetersMod.LOGGER.error("Recieved PacketUpdateRateLimit for unloaded position {}", (Object)pos);
                    return;
                }
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityEnergyMeterBase) {
                    ((TileEntityEnergyMeterBase)tile).handleRateLimitChangeRequest(message.rateLimit);
                    EnergyMetersMod.LOGGER.info("Recieved PacketUpdateRateLimit for {}", (Object)pos);
                } else {
                    EnergyMetersMod.LOGGER.error("Recieved PacketUpdateRateLimit for position with no TE: {}", (Object)pos);
                }
            });
            return null;
        }
    }
}

