/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.tile;

import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.energy.EnergyTypes;
import com.vladmarica.energymeters.energy.storage.EUStorage;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import com.vladmarica.energymeters.tile.config.EnumRedstoneControlState;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityEnergyMeterEU
extends TileEntityEnergyMeterBase {
    private EUStorage storage;
    private boolean addedToIC2EnergyNet = false;

    public TileEntityEnergyMeterEU() {
        super(EnergyTypes.EU);
    }

    @Override
    public void onLoad() {
        this.storage = new EUStorage(this);
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.addToEnergyNet();
        }
    }

    @Override
    public void func_73660_a() {
        NodeStats stats;
        if (!this.field_145850_b.field_72995_K && (stats = EnergyNet.instance.getNodeStats((IEnergyTile)this.storage)) != null) {
            this.totalEnergyTransferred = (long)((double)this.totalEnergyTransferred + stats.getEnergyIn());
        }
        super.func_73660_a();
    }

    @Override
    public int getEnergyScale() {
        return 1;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.removeFromEnergyNet();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeFromEnergyNet();
    }

    private void removeFromEnergyNet() {
        if (!this.field_145850_b.field_72995_K && this.addedToIC2EnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.storage));
            this.addedToIC2EnergyNet = false;
            EnergyMetersMod.LOGGER.debug("Remove EU meter {} from energy net", (Object)this.field_174879_c);
        }
    }

    private void addToEnergyNet() {
        if (!this.field_145850_b.field_72995_K && !this.addedToIC2EnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.storage));
            this.addedToIC2EnergyNet = true;
            EnergyMetersMod.LOGGER.debug("Added EU meter {} from energy net", (Object)this.field_174879_c);
        }
    }

    @Override
    public void handleSideUpdateRequest(@Nullable EnumFacing inputSide, @Nullable EnumFacing outputSide) {
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromEnergyNet();
            this.addToEnergyNet();
        }
        super.handleSideUpdateRequest(inputSide, outputSide);
    }

    @Override
    protected void checkConnections() {
        boolean connected = false;
        if (this.inputSide != null && this.outputSide != null) {
            BlockPos inputNeighbor = this.field_174879_c.func_177972_a(this.inputSide);
            BlockPos outputNeightbor = this.field_174879_c.func_177972_a(this.outputSide);
            IEnergyTile inputEnergyTile = EnergyNet.instance.getTile(this.field_145850_b, inputNeighbor);
            IEnergyTile outputEnergyTile = EnergyNet.instance.getTile(this.field_145850_b, outputNeightbor);
            boolean bl = connected = inputEnergyTile != null && outputEnergyTile != null;
        }
        if (connected != this.fullyConnected) {
            this.fullyConnected = connected;
            this.notifyUpdate();
        }
    }

    @Override
    public void handleConfigUpdateRequest(EnumRedstoneControlState redstoneControlState, int energyAliasIndex) {
        super.handleConfigUpdateRequest(redstoneControlState, energyAliasIndex);
        this.checkRedstone();
    }

    @Override
    protected void checkRedstone() {
        super.checkRedstone();
        if (this.isDisabled()) {
            this.removeFromEnergyNet();
        } else {
            this.addToEnergyNet();
        }
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return side == this.inputSide;
    }

    @Override
    public boolean canEmitEnergy(EnumFacing side) {
        return side == this.outputSide;
    }

    @Override
    public long receiveEnergy(long amount, boolean simulate, EnumFacing side) {
        return 0L;
    }
}

