/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.noise;

import java.awt.geom.Point2D;

public class VoronoiResult {
    private double shortestDistance = 3.2E7;
    private double nextDistance = 3.2E7;
    private double closestX = 3.2E7;
    private double closestZ = 3.2E7;

    public final double getShortestDistance() {
        return this.shortestDistance;
    }

    public final double getNextDistance() {
        return this.nextDistance;
    }

    public final double borderValue() {
        return this.shortestDistance / this.nextDistance;
    }

    public final double interiorValue() {
        return (this.nextDistance - this.shortestDistance) / this.nextDistance;
    }

    public final Point2D.Float toLength(Point2D.Float toMap, float radius) {
        double distance = toMap.distance(this.closestX, this.closestZ);
        double xDist = toMap.getX() - this.closestX;
        double zDist = toMap.getY() - this.closestZ;
        return new Point2D.Float((float)(this.closestX + (xDist *= (double)radius / distance)), (float)(this.closestZ + (zDist *= (double)radius / distance)));
    }

    void evaluate(Point2D.Double[] points, double x, double z) {
        for (Point2D.Double point : points) {
            double distance = point.distanceSq(x, z);
            if (distance < this.shortestDistance) {
                this.nextDistance = this.shortestDistance;
                this.shortestDistance = distance;
                this.closestX = point.getX();
                this.closestZ = point.getY();
                continue;
            }
            if (!(distance < this.nextDistance)) continue;
            this.nextDistance = distance;
        }
    }
}

