/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.WorldGenBlock;

public class DecoCobwebs
extends DecoBase {
    private static final IBlockState WEB = Blocks.field_150321_G.func_176223_P();
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private float strengthFactor;
    private int minY;
    private int maxY;
    private int chance;
    private IBlockState adjacentBlock;
    private int minAdjacents;

    public DecoCobwebs() {
        this.setStrengthFactor(2.0f);
        this.setMinY(1);
        this.setMaxY(255);
        this.setChance(10);
        this.setAdjacentBlock(Blocks.field_150350_a.func_176223_P());
        this.setMinAdjacents(1);
        this.addDecoTypes(DecoBase.DecoType.COBWEB);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        if (TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            int i = 0;
            while ((float)i < this.strengthFactor) {
                if (rand.nextInt(this.chance) == 0) {
                    new WorldGenBlock(WEB, AIR, this.adjacentBlock, this.minAdjacents).func_180709_b(rtgWorld.world(), rand, DecoCobwebs.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), DecoCobwebs.getRangedRandom(rand, this.minY, this.maxY), rand.nextInt(16)));
                }
                ++i;
            }
        }
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoCobwebs setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public DecoCobwebs setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoCobwebs setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public DecoCobwebs setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public IBlockState getAdjacentBlock() {
        return this.adjacentBlock;
    }

    public DecoCobwebs setAdjacentBlock(IBlockState adjacentBlock) {
        this.adjacentBlock = adjacentBlock;
        return this;
    }

    public int getMinAdjacents() {
        return this.minAdjacents;
    }

    public DecoCobwebs setMinAdjacents(int minAdjacents) {
        this.minAdjacents = minAdjacents;
        return this;
    }
}

