/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.WorldGenJungleCacti;

public class DecoJungleCacti
extends DecoBase {
    private float strengthFactor;
    private int maxY;
    private boolean sandOnly;
    private int extraHeight;

    public DecoJungleCacti() {
        this.setStrengthFactor(8.0f);
        this.setMaxY(255);
        this.setSandOnly(false);
        this.setExtraHeight(7);
        this.addDecoTypes(DecoBase.DecoType.CACTUS);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        if (TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            int i = 0;
            while ((float)i < this.strengthFactor) {
                BlockPos pos = DecoJungleCacti.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), rand.nextInt(this.maxY), rand.nextInt(16));
                new WorldGenJungleCacti(this.sandOnly, rand.nextInt(this.extraHeight)).func_180709_b(rtgWorld.world(), rand, pos);
                ++i;
            }
        }
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoJungleCacti setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoJungleCacti setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public boolean isSandOnly() {
        return this.sandOnly;
    }

    public DecoJungleCacti setSandOnly(boolean sandOnly) {
        this.sandOnly = sandOnly;
        return this;
    }

    public int getExtraHeight() {
        return this.extraHeight;
    }

    public DecoJungleCacti setExtraHeight(int extraHeight) {
        this.extraHeight = extraHeight;
        return this;
    }
}

