/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;

public class DecoReed
extends DecoBase {
    private float strengthFactor;
    private int maxY;
    private int loops;

    public DecoReed() {
        this.setMaxY(255);
        this.setStrengthFactor(0.0f);
        this.setLoops(1);
        this.addDecoTypes(DecoBase.DecoType.REED);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        if (TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            int loopCount = this.strengthFactor > 0.0f ? (int)this.strengthFactor : this.loops;
            for (int i = 0; i < loopCount; ++i) {
                BlockPos pos = DecoReed.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), rand.nextInt(this.maxY), rand.nextInt(16));
                new WorldGenReed().func_180709_b(rtgWorld.world(), rand, pos);
            }
        }
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoReed setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoReed setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public int getLoops() {
        return this.loops;
    }

    public DecoReed setLoops(int loops) {
        this.loops = loops;
        return this;
    }
}

