/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.terrain.heighteffect;

import java.awt.geom.Point2D;
import rtg.api.util.noise.VoronoiResult;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightEffect;

public class VoronoiPlateauEffect
extends HeightEffect {
    public float pointWavelength = 200.0f;
    public float minimumDivisor = 0.0f;
    public float adjustmentRadius = 3.0f;

    @Override
    public float added(RTGWorld rtgWorld, float x, float y) {
        Point2D.Float evaluateAt = new Point2D.Float(x / this.pointWavelength, y / this.pointWavelength);
        VoronoiResult points = rtgWorld.cellularInstance(1).eval2D(evaluateAt.x, evaluateAt.y);
        float raise = (float)points.interiorValue();
        Point2D.Float adjustAt = points.toLength(evaluateAt, this.adjustmentRadius);
        float multiplier = 1.3f;
        float noZeros = 0.1f;
        float adjustment = (float)rtgWorld.cellularInstance(2).eval2D(adjustAt.x, adjustAt.y).interiorValue() * multiplier + noZeros;
        float reAdjustment = (float)rtgWorld.cellularInstance(3).eval2D(adjustAt.x, adjustAt.y).interiorValue() * multiplier + noZeros;
        adjustment = TerrainBase.bayesianAdjustment(adjustment, reAdjustment);
        raise = TerrainBase.bayesianAdjustment(raise, adjustment);
        return raise;
    }
}

