/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPSnowyConiferousForest
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.snowy_coniferous_forest.orNull();
    public static Biome river = Biomes.field_76777_m;

    public RealisticBiomeBOPSnowyConiferousForest() {
        super(biome, RealisticBiomeBase.RiverType.FROZEN, RealisticBiomeBase.BeachType.COLD);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPSnowyConiferousForest(65.0f, 70.0f, 40.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPSnowyConiferousForest(this.getConfig(), BOPBlocks.grass.func_176223_P(), BOPBlocks.dirt.func_176223_P(), 0.45f, 1.5f, 50.0f, 60.0f, 0.4f, 100.0f, 50.0f, 1.5f);
    }

    @Override
    public void initDecos() {
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setMaxY(80);
        decoBoulder.setChance(16);
        decoBoulder.setStrengthFactor(1.0f);
        this.addDeco(decoBoulder);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree.setLogConditionChance(16);
        decoFallenTree.setLogBlock(BOPBlocks.log_0.func_176203_a(7));
        decoFallenTree.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(4);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
    }

    public static class SurfaceBOPSnowyConiferousForest
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float iCliff = 0.3f;
        private float iHeight = 100.0f;
        private float iStrength = 50.0f;
        private float cCliff = 1.5f;

        public SurfaceBOPSnowyConiferousForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff) {
            super(config, top, fill);
            this.min = minCliff;
        }

        public SurfaceBOPSnowyConiferousForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float snowCliff, float snowHeight, float snowStrength, float clayCliff) {
            this(config, top, fill, minCliff);
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.iCliff = snowCliff;
            this.iHeight = snowHeight;
            this.iStrength = snowStrength;
            this.cCliff = clayCliff;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if ((float)k > 110.0f + p * 4.0f && c < this.iCliff + ((float)k - this.iHeight) / this.iStrength + p) {
                        cliff = 3;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (cliff == 3) {
                        primer.func_177855_a(x, k, z, Blocks.field_150433_aE.func_176223_P());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, Blocks.field_150349_c.func_176223_P());
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                if (cliff == 3) {
                    primer.func_177855_a(x, k, z, Blocks.field_150433_aE.func_176223_P());
                    continue;
                }
                primer.func_177855_a(x, k, z, Blocks.field_150346_d.func_176223_P());
            }
        }
    }

    public static class TerrainBOPSnowyConiferousForest
    extends TerrainBase {
        private float minHeight;
        private float maxHeight;
        private float hillStrength;

        public TerrainBOPSnowyConiferousForest(float minHeight, float maxHeight, float hillStrength) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight > this.rollingHillsMaxHeight ? this.rollingHillsMaxHeight : (maxHeight < this.minHeight ? this.rollingHillsMaxHeight : maxHeight);
            this.hillStrength = hillStrength;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPSnowyConiferousForest.terrainRollingHills(x, y, rtgWorld, river, this.hillStrength, this.maxHeight, this.groundNoiseAmplitudeHills + 2.0f, 4.0f);
        }
    }
}

