/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.sugiforest;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.sugiforest.RealisticBiomeSFBase;

public class RealisticBiomeSFSugiForest
extends RealisticBiomeSFBase {
    private static IBlockState sugiLogBlock = BlockUtil.getBlockStateFromCfgString("sugiforest:sugi_log", Blocks.field_150364_r.func_176223_P());
    private static IBlockState sugiLeavesBlock = BlockUtil.getBlockStateFromCfgString("sugiforest:sugi_leaves", Blocks.field_150362_t.func_176223_P());

    public RealisticBiomeSFSugiForest(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainSFSugiForest();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceSFSugiForest(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 80.0f, -0.15f, 10.0f, 0.5f);
    }

    @Override
    public void initDecos() {
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree.getDistribution().setNoiseFactor(6.0f);
        decoFallenTree.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree.setLogConditionChance(24);
        decoFallenTree.setLogBlock(sugiLogBlock);
        decoFallenTree.setLeavesBlock(sugiLeavesBlock);
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(6);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoShrub decoShrubSugi = new DecoShrub();
        decoShrubSugi.setLogBlock(sugiLogBlock);
        decoShrubSugi.setLeavesBlock(sugiLeavesBlock);
        decoShrubSugi.setMaxY(90);
        decoShrubSugi.setLoopMultiplier(4.0f);
        decoShrubSugi.setChance(8);
        this.addDeco(decoShrubSugi);
        DecoShrub decoShrubOak = new DecoShrub();
        decoShrubOak.setMaxY(90);
        decoShrubOak.setLoopMultiplier(4.0f);
        decoShrubOak.setChance(4);
        this.addDeco(decoShrubOak);
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setChance(24);
        decoBoulder.setMaxY(80);
        decoBoulder.setStrengthFactor(2.0f);
        this.addDeco(decoBoulder);
    }

    public static class SurfaceSFSugiForest
    extends SurfaceBase {
        private IBlockState blockMixTop;
        private IBlockState blockMixFiller;
        private float floMixWidth;
        private float floMixHeight;
        private float floSmallWidth;
        private float floSmallStrength;

        public SurfaceSFSugiForest(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainSFSugiForest
    extends TerrainBase {
        private float baseHeight = 72.0f;
        private float peakyHillWavelength = 40.0f;
        private float peakyHillStrength = 10.0f;
        private float smoothHillWavelength = 20.0f;
        private float smoothHillStrength = 20.0f;

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainSFSugiForest.groundNoise(x, y, this.groundNoiseAmplitudeHills, rtgWorld);
            float h = TerrainSFSugiForest.terrainGrasslandHills(x, y, rtgWorld, river, this.peakyHillWavelength, this.peakyHillStrength, this.smoothHillWavelength, this.smoothHillStrength, this.baseHeight);
            return TerrainSFSugiForest.riverized(this.groundNoise + h, river);
        }
    }
}

