/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGBetulaPapyrifera;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaBirchForestM
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_185448_Z;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaBirchForestM() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaBirchForestM();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaBirchForestM(this.getConfig(), RealisticBiomeVanillaBirchForestM.biome.field_76752_A, RealisticBiomeVanillaBirchForestM.biome.field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, BlockUtil.getStateDirt(BlockDirt.DirtType.COARSE_DIRT), 0.15f);
    }

    @Override
    public void initDecos() {
        TreeRTGBetulaPapyrifera tallBirch = new TreeRTGBetulaPapyrifera();
        tallBirch.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH));
        tallBirch.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.BIRCH));
        tallBirch.setMinTrunkSize(16);
        tallBirch.setMaxTrunkSize(23);
        tallBirch.setMinCrownSize(4);
        tallBirch.setMaxCrownSize(11);
        this.addTree(tallBirch);
        DecoTree superTallBirch = new DecoTree(tallBirch);
        superTallBirch.setStrengthFactorForLoops(16.0f);
        superTallBirch.setStrengthNoiseFactorForLoops(true);
        superTallBirch.setTreeType(DecoTree.TreeType.RTG_TREE);
        superTallBirch.getDistribution().setNoiseDivisor(80.0f);
        superTallBirch.getDistribution().setNoiseFactor(60.0f);
        superTallBirch.getDistribution().setNoiseAddend(-15.0f);
        superTallBirch.setTreeCondition(DecoTree.TreeCondition.ALWAYS_GENERATE);
        superTallBirch.setMaxY(100);
        this.addDeco(superTallBirch);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenTree.setLogConditionChance(20);
        decoFallenTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH));
        decoFallenTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.BIRCH));
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(6);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoShrub decoShrub = new DecoShrub();
        decoShrub.setMaxY(110);
        decoShrub.setLoopMultiplier(2.0f);
        this.addDeco(decoShrub);
    }

    public static class SurfaceVanillaBirchForestM
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mixBlock;
        private float mixHeight;

        public SurfaceVanillaBirchForestM(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaBirchForestM
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaBirchForestM.terrainPlains(x, y, rtgWorld, river, 160.0f, 10.0f, 60.0f, 80.0f, 65.0f);
        }
    }
}

