/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.zoesteria;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.BumpyHillsEffect;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.world.biome.realistic.zoesteria.RealisticBiomeZOEBase;

public class RealisticBiomeZOESandDunes
extends RealisticBiomeZOEBase {
    public RealisticBiomeZOESandDunes(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPHighland();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPHighland(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    public static class SurfaceBOPHighland
    extends SurfaceBase {
        public SurfaceBOPHighland(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPHighland
    extends TerrainBase {
        private float baseHeight = 90.0f;
        private BumpyHillsEffect onTop = new BumpyHillsEffect();
        private JitterEffect withJitter;

        public TerrainBOPHighland() {
            this.onTop.hillHeight = 30.0f;
            this.onTop.hillWavelength = 60.0f;
            this.onTop.spikeHeight = 20.0f;
            this.onTop.spikeWavelength = 10.0f;
            this.withJitter = new JitterEffect();
            this.withJitter.amplitude = 2.0f;
            this.withJitter.wavelength = 5.0f;
            this.withJitter.jittered = this.onTop;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPHighland.riverized(this.baseHeight + this.withJitter.added(rtgWorld, x, y) + TerrainBOPHighland.groundNoise(x, y, 6.0f, rtgWorld), river);
        }
    }
}

