/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.util;

import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;

public class BetterCavesUtils {
    private BetterCavesUtils() {
    }

    public static int getMaxSurfaceAltitudeChunk(ChunkPrimer primer) {
        int[] testCoords;
        int maxHeight = 0;
        for (int x : testCoords = new int[]{0, 7, 15}) {
            for (int z : testCoords) {
                maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, x, z));
            }
        }
        return maxHeight;
    }

    public static int getMinSurfaceAltitudeChunk(ChunkPrimer primer) {
        int[] testCoords;
        int minHeight = 256;
        for (int x : testCoords = new int[]{0, 7, 15}) {
            for (int z : testCoords) {
                minHeight = Math.min(minHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, x, z));
            }
        }
        return minHeight;
    }

    public static int estimateMaxSurfaceAltitudeSubChunk(ChunkPrimer primer, BlockPos startPos, int subChunkSize) {
        int maxHeight = 0;
        int startX = BetterCavesUtils.getLocal(startPos.func_177958_n());
        int startZ = BetterCavesUtils.getLocal(startPos.func_177952_p());
        int endX = startX + subChunkSize - 1;
        int endZ = startZ + subChunkSize - 1;
        if (subChunkSize == 1) {
            return Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, startZ));
        }
        maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, startZ));
        maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, endZ));
        maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, endX, startZ));
        maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, endX, endZ));
        return maxHeight;
    }

    public static int estimateMinSurfaceAltitudeSubChunk(ChunkPrimer primer, BlockPos startPos, int subChunkSize) {
        int minHeight = 255;
        int startX = BetterCavesUtils.getLocal(startPos.func_177958_n());
        int startZ = BetterCavesUtils.getLocal(startPos.func_177952_p());
        int endX = startX + subChunkSize - 1;
        int endZ = startZ + subChunkSize - 1;
        if (subChunkSize == 1) {
            return Math.min(minHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, startZ));
        }
        minHeight = Math.min(minHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, startZ));
        minHeight = Math.min(minHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, endZ));
        minHeight = Math.min(minHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, endX, startZ));
        minHeight = Math.min(minHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(primer, endX, endZ));
        return minHeight;
    }

    public static int estimateAvgSurfaceAltitudeSubChunk(ChunkPrimer primer, BlockPos startPos, int subChunkSize) {
        int avgHeight = 0;
        int startX = BetterCavesUtils.getLocal(startPos.func_177958_n());
        int startZ = BetterCavesUtils.getLocal(startPos.func_177952_p());
        int endX = startX + subChunkSize - 1;
        int endZ = startZ + subChunkSize - 1;
        if (subChunkSize == 1) {
            return BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, startZ);
        }
        avgHeight += BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, startZ);
        avgHeight += BetterCavesUtils.getSurfaceAltitudeForColumn(primer, startX, endZ);
        avgHeight += BetterCavesUtils.getSurfaceAltitudeForColumn(primer, endX, startZ);
        avgHeight += BetterCavesUtils.getSurfaceAltitudeForColumn(primer, endX, endZ);
        return avgHeight /= 4;
    }

    public static int getSurfaceAltitudeForColumn(ChunkPrimer primer, int localX, int localZ) {
        return BetterCavesUtils.searchSurfaceAltitudeInRangeForColumn(primer, localX, localZ, 255, 0);
    }

    public static int searchSurfaceAltitudeInRangeForColumn(ChunkPrimer primer, int localX, int localZ, int topY, int bottomY) {
        if (topY == 255 && primer.func_177856_a(localX, 255, localZ) != Blocks.field_150350_a.func_176223_P() && primer.func_177856_a(localX, 255, localZ).func_185904_a() != Material.field_151586_h) {
            return 255;
        }
        for (int y = bottomY; y <= topY; ++y) {
            IBlockState blockState = primer.func_177856_a(localX, y, localZ);
            if (blockState != Blocks.field_150350_a.func_176223_P() && blockState.func_185904_a() != Material.field_151586_h) continue;
            return y;
        }
        return 1;
    }

    public static String dimensionAsString(int dimensionID, String dimensionName) {
        return String.format("%d (%s)", dimensionID, dimensionName);
    }

    public static int getLocal(int coordinate) {
        return coordinate & 0xF;
    }

    public static boolean isDimensionWhitelisted(int dimID) {
        if (Configuration.enableGlobalWhitelist) {
            return true;
        }
        for (int dim : Configuration.whitelistedDimensionIDs) {
            if (dimID != dim) continue;
            return true;
        }
        return false;
    }
}

