/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.items.IItemHandler;

public class SortingHandler {
    public static void sortInventory(IItemHandler handler) {
        SortingHandler.sortInventory(handler, 0);
    }

    public static void sortInventory(IItemHandler handler, int iStart) {
        SortingHandler.sortInventory(handler, iStart, handler.getSlots());
    }

    public static void sortInventory(IItemHandler handler, int iStart, int iEnd) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> restore = new ArrayList<ItemStack>();
        for (int i = iStart; i < iEnd; ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            restore.add(stackAt.func_77946_l());
            if (stackAt.func_190926_b()) continue;
            stacks.add(stackAt.func_77946_l());
        }
        SortingHandler.mergeStacks(stacks);
        if (SortingHandler.setInventory(handler, stacks, iStart, iEnd) == EnumActionResult.FAIL) {
            SortingHandler.setInventory(handler, restore, iStart, iEnd);
        }
    }

    private static EnumActionResult setInventory(IItemHandler inventory, List<ItemStack> stacks, int iStart, int iEnd) {
        for (int i = iStart; i < iEnd; ++i) {
            int j = i - iStart;
            ItemStack stack = j >= stacks.size() ? ItemStack.field_190927_a : stacks.get(j);
            inventory.extractItem(i, 64, false);
            if (stack.func_190926_b() || inventory.insertItem(i, stack, false).func_190926_b()) continue;
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    private static void mergeStacks(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack set = SortingHandler.mergeStackWithOthers(list, i);
            list.set(i, set);
        }
        list.removeIf(stack -> stack.func_190926_b() || stack.func_190916_E() == 0);
    }

    private static ItemStack mergeStackWithOthers(List<ItemStack> list, int index) {
        ItemStack stack = list.get(index);
        if (stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stackAt;
            if (i == index || (stackAt = list.get(i)).func_190926_b() || stackAt.func_190916_E() >= stackAt.func_77976_d() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stackAt) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackAt)) continue;
            int setSize = stackAt.func_190916_E() + stack.func_190916_E();
            int carryover = Math.max(0, setSize - stackAt.func_77976_d());
            stackAt.func_190920_e(carryover);
            stack.func_190920_e(setSize - carryover);
            if (stack.func_190916_E() != stack.func_77976_d()) continue;
            return stack;
        }
        return stack;
    }
}

