/*
 * Decompiled with CFR 0.152.
 */
package techguns;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import techguns.TGConfig;
import techguns.TGItems;
import techguns.api.radiation.TGRadiation;
import techguns.init.ITGInitializer;
import techguns.radiation.ItemRadiationRegistry;
import techguns.radiation.RadRegenerationPotion;
import techguns.radiation.RadResistancePotion;
import techguns.radiation.RadiationPotion;

public class TGRadiationSystem
implements ITGInitializer {
    public static final Predicate<Entity> RADIATION_TARGETS = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input instanceof EntityLivingBase;
        }
    };
    public static RadiationPotion radiation_effect;
    public static RadResistancePotion radresistance_effect;
    public static RadRegenerationPotion radregen_effect;
    public static int MINOR_POISONING;
    public static int SEVERE_POISONING;
    public static int LETHAL_POISONING;
    public static int RADLOST_ON_DEATH;
    public static final int INVENTORY_RADIATION_INVERVALL = 60;
    public static PotionType RAD_POTION;
    public static PotionType RAD_RESISTANCE_POTION;
    public static PotionType RAD_REGENERATION_POTION;
    public static PotionType RAD_POTION_SEVERE;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        TGRadiation.RADIATION_RESISTANCE = new RangedAttribute((IAttribute)null, "techguns.radiationResistance", 0.0, 0.0, 3.4028234663852886E38).func_111112_a(true);
        radiation_effect = new RadiationPotion();
        radiation_effect.func_76390_b("techguns.radiation").setRegistryName(new ResourceLocation("techguns", "radiation"));
        radregen_effect = new RadRegenerationPotion();
        radregen_effect.func_76390_b("techguns.radregeneration").setRegistryName(new ResourceLocation("techguns", "radregeneration"));
        radresistance_effect = new RadResistancePotion();
        ((Potion)radresistance_effect.func_76390_b("techguns.radresistance").setRegistryName(new ResourceLocation("techguns", "radresistance"))).func_188413_j().func_111184_a(TGRadiation.RADIATION_RESISTANCE, "515AD21C-3FB2-4E36-BBCE-88C2ED738DE2", 1.0, 0);
    }

    public static boolean isEnabled() {
        return !TGConfig.WIP_disableRadiationSystem;
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (TGRadiationSystem.isEnabled()) {
            ItemRadiationRegistry.addRadiationData(TGItems.ENRICHED_URANIUM, 3, 100);
            ItemRadiationRegistry.addRadiationData(TGItems.YELLOWCAKE, 1, 100);
            ItemRadiationRegistry.addRadiationData(TGItems.ANTI_GRAV_CORE, 4, 100);
            ItemRadiationRegistry.addRadiationData(TGItems.PLASMA_GENERATOR, 4, 100);
            ItemRadiationRegistry.addRadiationData(TGItems.TACTICAL_NUKE_WARHEAD, 1, 100);
            ItemRadiationRegistry.addRadiationData(TGItems.ROCKET_NUKE, 1, 100);
            OreDictionary.getOres((String)"ore_uranium").forEach(o -> ItemRadiationRegistry.addRadiationData(o, 1, 100));
            OreDictionary.getOres((String)"ingot_uranium").forEach(o -> ItemRadiationRegistry.addRadiationData(o, 1, 100));
        }
    }

    public void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)radiation_effect);
        event.getRegistry().register((IForgeRegistryEntry)radresistance_effect);
        event.getRegistry().register((IForgeRegistryEntry)radregen_effect);
    }

    public static void applyRadToEntities(TileEntity tile, double radius, int duration, int strength, double inner_radius, int strength_outer) {
        TGRadiationSystem.applyRadToEntities(tile.func_145831_w(), (double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5, radius, duration, strength, inner_radius, strength_outer);
    }

    public static void applyRadToEntities(World world, double posX, double posY, double posZ, double radius, int duration, int strength, double inner_radius, int strength_outer) {
        Vec3d offset = new Vec3d(posX + radius, posY + radius, posZ + radius);
        Vec3d offset2 = new Vec3d(posX - radius, posY - radius, posZ - radius);
        AxisAlignedBB bb = new AxisAlignedBB(offset, offset2);
        Vec3d pos = new Vec3d(posX, posY, posZ);
        world.func_175647_a(EntityLivingBase.class, bb, RADIATION_TARGETS).forEach(e -> {
            double distance = pos.func_72438_d(new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v));
            if (distance < radius) {
                int str = strength;
                if (distance > inner_radius) {
                    double factor = (distance - inner_radius) / (radius - inner_radius);
                    str = (int)Math.round((double)strength_outer + (double)(strength - strength_outer) * factor);
                }
                EntityLivingBase elb = e;
                elb.func_70690_d(new PotionEffect((Potion)radiation_effect, duration, str, true, true));
            }
        });
    }

    static {
        MINOR_POISONING = 500;
        SEVERE_POISONING = 750;
        LETHAL_POISONING = 1000;
        RADLOST_ON_DEATH = 200;
    }
}

