/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.blocks.GenericBlock;
import techguns.blocks.GenericItemBlockMeta;
import techguns.items.armors.ICamoChangeable;
import techguns.util.BlockUtils;

public class BlockTGLadder<T extends Enum<T>>
extends GenericBlock
implements ICamoChangeable {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final double LADDER_SIZE = 0.125;
    protected static final AxisAlignedBB LADDER_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB LADDER_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected BlockStateContainer blockStateOverride;
    public PropertyEnum<T> TYPE;
    protected Class<T> clazz;
    protected GenericItemBlockMeta itemblock;

    public BlockTGLadder(String name, Class<T> clazz) {
        super(name, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.clazz = clazz;
        this.TYPE = PropertyEnum.func_177709_a((String)"type", clazz);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.TYPE}).add(new IProperty[]{FACING}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return LADDER_NORTH_AABB;
            }
            case SOUTH: {
                return LADDER_SOUTH_AABB;
            }
            case WEST: {
                return LADDER_WEST_AABB;
            }
        }
        return LADDER_EAST_AABB;
    }

    public BlockStateContainer func_176194_O() {
        return this.blockStateOverride;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState basetype = this.func_176203_a(meta);
        if (facing.func_176740_k().func_176722_c()) {
            return basetype.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockTGLadder) {
            IBlockState statedown = worldIn.func_180495_p(pos.func_177977_b());
            return basetype.func_177226_a((IProperty)FACING, statedown.func_177229_b((IProperty)FACING));
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockTGLadder) {
            IBlockState stateup = worldIn.func_180495_p(pos.func_177984_a());
            return basetype.func_177226_a((IProperty)FACING, stateup.func_177229_b((IProperty)FACING));
        }
        return basetype.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P().func_177226_a(this.TYPE, state.func_177229_b(this.TYPE)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2 | ((Enum)((Object)state.func_177229_b(this.TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta >> 2))).func_177226_a(this.TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[meta & 3]));
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (Enum t : (Enum[])this.clazz.getEnumConstants()) {
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(this.TYPE, (Comparable)((Object)t)))));
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176746_e());
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176735_f());
            }
        }
        return state;
    }

    @Override
    public ItemBlock createItemBlock() {
        this.itemblock = new GenericItemBlockMeta(this);
        return this.itemblock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        for (int i = 0; i < ((Enum[])this.clazz.getEnumConstants()).length; ++i) {
            IBlockState state = this.func_176223_P().func_177226_a(this.TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[i]));
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), BlockUtils.getBlockStateVariantString(state)));
        }
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b(facing));
    }

    @Override
    public int getCamoCount() {
        return ((Enum[])this.clazz.getEnumConstants()).length - 1;
    }

    @Override
    public int getCurrentCamoIndex(ItemStack item) {
        int meta = item.func_77960_j();
        IBlockState state = this.func_176203_a(meta);
        return ((Enum)((Object)state.func_177229_b(this.TYPE))).ordinal();
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        return "techguns." + this.getRegistryName().func_110623_a() + ".camoname." + this.getCurrentCamoIndex(item);
    }

    @Override
    public int switchCamo(ItemStack item, boolean back) {
        IBlockState state = this.func_176203_a(item.func_77960_j());
        int type = ((Enum)((Object)state.func_177229_b(this.TYPE))).ordinal();
        if (back) {
            if (--type < 0) {
                type = ((Enum[])this.clazz.getEnumConstants()).length - 1;
            }
        } else if (++type >= ((Enum[])this.clazz.getEnumConstants()).length) {
            type = 0;
        }
        int newmeta = this.func_176201_c(state.func_177226_a(this.TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[type])));
        item.func_77964_b(newmeta);
        return newmeta;
    }

    @Override
    public int getFirstItemCamoDamageValue() {
        return this.func_176201_c(this.func_176223_P().func_177226_a(this.TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[0])));
    }
}

