/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines.multiblocks;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.machines.EnumMultiBlockMachineType;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.blocks.machines.multiblocks.MultiBlockMachineSchematic;
import techguns.blocks.machines.multiblocks.SlavePos;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.ReactionChamberTileEntMaster;

public class ReactionChamberDefinition
extends MultiBlockMachineSchematic {
    public static final float BOTTOM_DIFF = 0.25f;
    public static final float MIDDLE_DIFF = 0.45f;
    public static final float HEIGHT_DIFF = 0.35f;
    public static HashMap<SlavePos, AxisAlignedBB> boundingBoxes = new HashMap();

    public ReactionChamberDefinition() {
        super(ReactionChamberTileEntMaster.class);
    }

    protected ArrayList<BlockPos> getGlassBlocks(BlockPos masterPos, EnumFacing direction) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos pos = masterPos.func_185334_h();
        EnumFacing left = direction.func_176746_e();
        BlockPos pos1 = pos.func_177972_a(left).func_177984_a();
        BlockPos pos2 = pos.func_177972_a(left.func_176734_d()).func_177967_a(direction, 2).func_177981_b(2);
        BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2).forEach(p -> positions.add((BlockPos)p));
        return positions;
    }

    protected ArrayList<BlockPos> getEnergyConnector(BlockPos masterPos, EnumFacing direction) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos pos = masterPos.func_185334_h();
        positions.add(pos.func_177972_a(direction).func_177981_b(3));
        return positions;
    }

    protected ArrayList<BlockPos> getSideConnectors(BlockPos masterPos, EnumFacing direction) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos center = masterPos.func_185334_h().func_177972_a(direction);
        EnumFacing left = direction.func_176746_e();
        positions.add(center.func_177972_a(direction));
        positions.add(center.func_177972_a(left));
        positions.add(center.func_177972_a(left.func_176734_d()));
        return positions;
    }

    protected ArrayList<BlockPos> getNoConnectorHousings(BlockPos masterPos, EnumFacing direction) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos pos = masterPos.func_185334_h();
        EnumFacing left = direction.func_176746_e();
        BlockPos leftp = pos.func_177972_a(left);
        BlockPos rightp = pos.func_177972_a(left.func_176734_d());
        BlockPos centerp = pos.func_177972_a(direction);
        positions.add(leftp);
        positions.add(rightp);
        positions.add(leftp.func_177967_a(direction, 2));
        positions.add(rightp.func_177967_a(direction, 2));
        positions.add(centerp);
        positions.add(leftp.func_177981_b(3));
        positions.add(rightp.func_177981_b(3));
        positions.add(leftp.func_177967_a(direction, 2).func_177981_b(3));
        positions.add(rightp.func_177967_a(direction, 2).func_177981_b(3));
        BlockPos centeru = centerp.func_177981_b(3);
        positions.add(centeru.func_177972_a(direction));
        positions.add(centeru.func_177972_a(direction.func_176734_d()));
        positions.add(centeru.func_177972_a(left));
        positions.add(centeru.func_177972_a(left.func_176734_d()));
        return positions;
    }

    protected ArrayList<BlockPos> getHousingBlocks(BlockPos masterPos, EnumFacing direction) {
        ArrayList<BlockPos> positions = this.getNoConnectorHousings(masterPos, direction);
        positions.addAll(this.getEnergyConnector(masterPos, direction));
        positions.addAll(this.getSideConnectors(masterPos, direction));
        return positions;
    }

    @Override
    public boolean checkForm(World w, EntityPlayer player, BlockPos masterPos, EnumFacing direction) {
        EnumFacing dir = direction.func_176734_d();
        IBlockState unformedHousing = TGBlocks.MULTIBLOCK_MACHINE.func_176223_P().func_177226_a((IProperty)TGBlocks.MULTIBLOCK_MACHINE.MACHINE_TYPE, (Comparable)((Object)EnumMultiBlockMachineType.REACTIONCHAMBER_HOUSING)).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false));
        IBlockState unformedGlass = TGBlocks.MULTIBLOCK_MACHINE.func_176223_P().func_177226_a((IProperty)TGBlocks.MULTIBLOCK_MACHINE.MACHINE_TYPE, (Comparable)((Object)EnumMultiBlockMachineType.REACTIONCHAMBER_GLASS)).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false));
        if (this.canFormFromSide(dir) && ReactionChamberDefinition.allBlocksMatch(w, player, this.getGlassBlocks(masterPos, dir), unformedGlass) && ReactionChamberDefinition.allBlocksMatch(w, player, this.getHousingBlocks(masterPos, dir), unformedHousing)) {
            return true;
        }
        ReactionChamberDefinition.sendErrorMSG(w, masterPos, player, 8);
        return false;
    }

    @Override
    public boolean form(World w, EntityPlayer player, BlockPos masterPos, EnumFacing direction) {
        EnumFacing dir = direction.func_176734_d();
        TileEntity tile = w.func_175625_s(masterPos);
        if (tile != null && tile instanceof MultiBlockMachineTileEntMaster) {
            MultiBlockMachineTileEntMaster master = (MultiBlockMachineTileEntMaster)tile;
            master.form(dir);
            ArrayList<BlockPos> housings_EnergyConnector = this.getEnergyConnector(masterPos, dir);
            ArrayList<BlockPos> housings_SideConnectors = this.getSideConnectors(masterPos, dir);
            ArrayList<BlockPos> housings_noConnection = this.getNoConnectorHousings(masterPos, dir);
            ArrayList<BlockPos> glassBlocks = this.getGlassBlocks(masterPos, dir);
            glassBlocks.forEach(b -> this.linkSlave(w, player, (BlockPos)b, 1, masterPos));
            housings_noConnection.forEach(b -> this.linkSlave(w, player, (BlockPos)b, 1, masterPos));
            housings_SideConnectors.forEach(b -> this.linkSlave(w, player, (BlockPos)b, 2, masterPos));
            housings_EnergyConnector.forEach(b -> this.linkSlave(w, player, (BlockPos)b, 3, masterPos));
        }
        return false;
    }

    @Override
    public void unform(World w, MultiBlockMachineTileEntMaster master) {
        BlockPos masterPos = master.func_174877_v();
        EnumFacing direction = master.getMultiblockDirection();
        master.unform();
        ArrayList<BlockPos> glassBlocks = this.getGlassBlocks(masterPos, direction);
        ArrayList<BlockPos> housingBlocks = this.getHousingBlocks(masterPos, direction);
        glassBlocks.forEach(b -> this.unlinkSlave(w, (BlockPos)b));
        housingBlocks.forEach(b -> this.unlinkSlave(w, (BlockPos)b));
    }

    @Override
    public boolean canFormFromSide(EnumFacing side) {
        return side != null && side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    static {
        boundingBoxes.put(new SlavePos(-1, 0, -1), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(1, 0, -1), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(-1, 0, 1), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75));
        boundingBoxes.put(new SlavePos(1, 0, 1), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75));
        boundingBoxes.put(new SlavePos(-1, 1, -1), new AxisAlignedBB((double)0.45f, 0.0, (double)0.45f, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(1, 1, -1), new AxisAlignedBB(0.0, 0.0, (double)0.45f, (double)0.55f, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(-1, 1, 1), new AxisAlignedBB((double)0.45f, 0.0, 0.0, 1.0, 1.0, (double)0.55f));
        boundingBoxes.put(new SlavePos(1, 1, 1), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.55f, 1.0, (double)0.55f));
        boundingBoxes.put(new SlavePos(-1, 1, 0), new AxisAlignedBB((double)0.45f, 0.0, 0.0, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(1, 1, 0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.55f, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(0, 1, -1), new AxisAlignedBB(0.0, 0.0, (double)0.45f, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(0, 1, 1), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.55f));
        boundingBoxes.put(new SlavePos(-1, 2, -1), new AxisAlignedBB((double)0.45f, 0.0, (double)0.45f, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(1, 2, -1), new AxisAlignedBB(0.0, 0.0, (double)0.45f, (double)0.55f, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(-1, 2, 1), new AxisAlignedBB((double)0.45f, 0.0, 0.0, 1.0, 1.0, (double)0.55f));
        boundingBoxes.put(new SlavePos(1, 2, 1), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.55f, 1.0, (double)0.55f));
        boundingBoxes.put(new SlavePos(-1, 2, 0), new AxisAlignedBB((double)0.45f, 0.0, 0.0, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(1, 2, 0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.55f, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(0, 2, -1), new AxisAlignedBB(0.0, 0.0, (double)0.45f, 1.0, 1.0, 1.0));
        boundingBoxes.put(new SlavePos(0, 2, 1), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.55f));
        boundingBoxes.put(new SlavePos(-1, 3, -1), new AxisAlignedBB((double)0.45f, 0.0, (double)0.45f, 1.0, (double)0.65f, 1.0));
        boundingBoxes.put(new SlavePos(1, 3, -1), new AxisAlignedBB(0.0, 0.0, (double)0.45f, (double)0.55f, (double)0.65f, 1.0));
        boundingBoxes.put(new SlavePos(-1, 3, 1), new AxisAlignedBB((double)0.45f, 0.0, 0.0, 1.0, (double)0.65f, (double)0.55f));
        boundingBoxes.put(new SlavePos(1, 3, 1), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.55f, (double)0.65f, (double)0.55f));
        boundingBoxes.put(new SlavePos(-1, 3, 0), new AxisAlignedBB((double)0.45f, 0.0, 0.0, 1.0, (double)0.65f, 1.0));
        boundingBoxes.put(new SlavePos(1, 3, 0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.55f, (double)0.65f, 1.0));
        boundingBoxes.put(new SlavePos(0, 3, -1), new AxisAlignedBB(0.0, 0.0, (double)0.45f, 1.0, (double)0.65f, 1.0));
        boundingBoxes.put(new SlavePos(0, 3, 1), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.65f, (double)0.55f));
    }
}

