/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.projectiles;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import techguns.client.render.TGRenderHelper;
import techguns.entities.projectiles.LaserProjectile;

public class RenderLaserProjectile
extends Render<LaserProjectile> {
    private ResourceLocation texture = new ResourceLocation("techguns:textures/fx/laser3.png");
    private ResourceLocation textureStart = new ResourceLocation("techguns:textures/fx/laser3_start.png");
    private double laserWidth = 3.0;
    private TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;

    public RenderLaserProjectile(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(LaserProjectile laser, double x, double y, double z, float entityYaw, float partialTicks) {
        int i;
        double distance = laser.distance;
        short maxTicks = laser.maxTicks;
        float prog = (float)laser.field_70173_aa / (float)maxTicks;
        double width = this.laserWidth * Math.sin(Math.sqrt(prog) * Math.PI) * 2.0;
        double distance_start = Math.min(1.0, distance);
        double u = distance / this.laserWidth * 2.0;
        this.func_180548_c(laser);
        GlStateManager.func_179094_E();
        TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179091_B();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(laser.laserYaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)laser.laserPitch, (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f10 = 0.0125f;
        distance *= 80.0;
        distance_start *= 80.0;
        float rot_x = 45.0f + prog * 180.0f;
        GlStateManager.func_179114_b((float)(rot_x + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)f10, (float)f10, (float)f10);
        float brightness = (float)Math.sin(Math.sqrt(prog) * Math.PI);
        if (distance > distance_start) {
            GlStateManager.func_179094_E();
            for (i = 0; i < 2; ++i) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)f10);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b(distance, -width, 0.0).func_187315_a(u + (double)prog, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
                bufferbuilder.func_181662_b(distance_start, -width, 0.0).func_187315_a((double)prog, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
                bufferbuilder.func_181662_b(distance_start, width, 0.0).func_187315_a((double)prog, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
                bufferbuilder.func_181662_b(distance, width, 0.0).func_187315_a(u + (double)prog, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
                tessellator.func_78381_a();
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        this.field_76990_c.field_78724_e.func_110577_a(this.textureStart);
        for (i = 0; i < 2; ++i) {
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)f10);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(distance_start, -width, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(0.0, -width, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(0.0, width, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(distance_start, width, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179101_C();
        TGRenderHelper.disableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(LaserProjectile entity) {
        return this.texture;
    }
}

