/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npcs;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.npc.INpcTGDamageSystem;
import techguns.capabilities.TGSpawnerNPCData;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npcs.ITGSpawnerNPC;
import techguns.entities.projectiles.AlienBlasterProjectile;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.packets.PacketPlaySound;

public class Ghastling
extends EntityMob
implements IMob,
INpcTGDamageSystem,
INPCTechgunsShooter,
ITGSpawnerNPC {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(Ghastling.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final ResourceLocation LOOT = new ResourceLocation("techguns", "entities/ghastling");
    protected boolean tryLink = true;

    public Ghastling(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 2.1f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(0.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    public float func_70047_e() {
        return 1.5f;
    }

    @Override
    public float getWeaponPosX() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosY() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosZ() {
        return 0.0f;
    }

    @Override
    public float getTotalArmorAgainstType(TGDamageSource dmgsrc) {
        return 0.0f;
    }

    @Override
    public float getPenetrationResistance(TGDamageSource dmgsrc) {
        return 0.0f;
    }

    @Override
    public boolean getTryLink() {
        return this.tryLink;
    }

    @Override
    public void setTryLink(boolean value) {
        this.tryLink = value;
    }

    @Override
    public TGSpawnerNPCData getCapability(Capability<TGSpawnerNPCData> tgGenericnpcData) {
        return (TGSpawnerNPCData)this.getCapability(tgGenericnpcData, null);
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
        this.despawnEntitySpawner(this.field_70170_p, this.field_70729_aU);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.onDeathSpawner(this.field_70170_p, this.field_70729_aU);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.onUpdateSpawner(this.field_70170_p);
    }

    protected static class AIFireballAttack
    extends EntityAIBase {
        private final Ghastling parentEntity;
        private int attackStep;
        private int attackTime;

        public AIFireballAttack(Ghastling mob) {
            this.parentEntity = mob;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = this.parentEntity.func_70068_e((Entity)entitylivingbase);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.parentEntity.func_70652_k((Entity)entitylivingbase);
                }
                this.parentEntity.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance()) {
                double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 30;
                        this.parentEntity.setAttacking(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 50;
                        this.attackStep = 0;
                        this.parentEntity.setAttacking(false);
                    }
                    if (this.attackStep > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        this.parentEntity.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.parentEntity.field_70165_t, (int)this.parentEntity.field_70163_u, (int)this.parentEntity.field_70161_v), 0);
                        AlienBlasterProjectile rocket = new AlienBlasterProjectile(this.parentEntity.field_70170_p, (EntityLivingBase)this.parentEntity, 6.0f, 1.5f, 200, 0.05f, 200.0f, 200.0f, 6.0f, 0.0f, false, EnumBulletFirePos.CENTER);
                        this.parentEntity.field_70170_p.func_72838_d((Entity)rocket);
                    }
                }
                this.parentEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            } else {
                this.parentEntity.func_70661_as().func_75499_g();
                this.parentEntity.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            IAttributeInstance iattributeinstance = this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        }
    }

    protected static class AIGhastlingAttack
    extends EntityAIBase {
        private final Ghastling parentEntity;
        public int attackTimer;

        public AIGhastlingAttack(Ghastling mob) {
            this.parentEntity = mob;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 15) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.NETHERBLASTER_FIRE, (Entity)this.parentEntity, 1.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE), TGPackets.targetPointAroundEnt((Entity)this.parentEntity, 100.0));
                    AlienBlasterProjectile rocket = new AlienBlasterProjectile(this.parentEntity.field_70170_p, (EntityLivingBase)this.parentEntity, 10.0f, 1.5f, 200, 0.05f, 200.0f, 200.0f, 10.0f, 0.0f, false, EnumBulletFirePos.CENTER);
                    world.func_72838_d((Entity)rocket);
                } else if (this.attackTimer > 30) {
                    this.attackTimer = 0;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }
    }
}

