/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npcs;

import com.google.common.base.Predicate;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.npc.factions.ITGNpcTeam;
import techguns.api.npc.factions.TGNpcFaction;
import techguns.entities.ai.EntityAIHurtByTargetTGFactions;
import techguns.entities.ai.EntityAIRangedAttack;
import techguns.entities.ai.TurretEntityAINearestAttackableTarget;
import techguns.entities.ai.TurretEntityAIWatchClosest;
import techguns.factions.TGNpcFactions;
import techguns.items.guns.GenericGun;
import techguns.tileentities.TurretTileEnt;

public class NPCTurret
extends EntityCreature
implements IAnimals,
IRangedAttackMob,
INPCTechgunsShooter,
ITGNpcTeam {
    private static final ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("techguns", "textures/blocks/turret_base.png"), new ResourceLocation("techguns", "textures/blocks/turret_base2.png"), new ResourceLocation("techguns", "textures/blocks/turret_base3.png"), new ResourceLocation("techguns", "textures/blocks/turret_base4.png"), new ResourceLocation("techguns", "textures/blocks/turret_base5.png")};
    protected TurretEntityAIWatchClosest aiWatch = null;
    protected EntityAILookIdle aiIdle = null;
    protected EntityAIHurtByTargetTGFactions aiHurt = null;
    protected TurretEntityAINearestAttackableTarget aiTarget = null;
    private EntityAIRangedAttack aiRangedAttack = null;
    public TurretTileEnt mountedTileEnt = null;
    public boolean active = true;
    protected EnumFacing turretFacing = EnumFacing.UP;
    protected int networkUpdateRequestDelay = 0;

    public NPCTurret(World world) {
        super(world);
        this.setAITasks();
        this.func_189654_d(true);
        this.mountedTileEnt = null;
        this.field_70131_O = 0.9f;
    }

    public NPCTurret(World world, TurretTileEnt mountedTileEnt) {
        super(world);
        this.setAITasks();
        this.func_189654_d(true);
        this.mountedTileEnt = mountedTileEnt;
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
        this.field_70131_O = 0.9f;
    }

    public static ResourceLocation getTexture(int tier) {
        return textures[tier];
    }

    public ResourceLocation getTexture() {
        int tier = 0;
        if (this.mountedTileEnt != null) {
            tier = this.mountedTileEnt.getTurretTier();
        }
        return NPCTurret.getTexture(tier);
    }

    public float func_70047_e() {
        if (this.turretFacing == EnumFacing.DOWN) {
            return 0.15f;
        }
        return 0.75f;
    }

    public boolean func_70686_a(Class target) {
        return true;
    }

    public ItemStack func_184614_ca() {
        return this.getWeapon();
    }

    protected ItemStack getWeapon() {
        if (this.mountedTileEnt != null) {
            return this.mountedTileEnt.getWeapon();
        }
        return ItemStack.field_190927_a;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    public void func_70645_a(DamageSource damageSource) {
        if (this.mountedTileEnt != null) {
            this.mountedTileEnt.onTurretDeath();
        }
    }

    protected void func_70628_a(boolean hitByPlayer, int level) {
    }

    protected ItemStack getRandomItemFromLoottable() {
        return ItemStack.field_190927_a;
    }

    public void setTileEnt(TurretTileEnt ent) {
        this.mountedTileEnt = ent;
        this.setCombatTask();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70107_b(this.field_70169_q, this.field_70167_r, this.field_70166_s);
        if (!this.field_70170_p.field_72995_K) {
            if (this.mountedTileEnt == null) {
                int z;
                TileEntity tile;
                int x = (int)Math.floor(this.field_70165_t);
                int y = (int)Math.round(this.field_70163_u) - 1;
                if (this.turretFacing == EnumFacing.DOWN) {
                    y = (int)Math.round(this.field_70163_u) + 1;
                }
                if ((tile = this.field_70170_p.func_175625_s(new BlockPos(x, y, z = (int)Math.floor(this.field_70161_v)))) != null && tile instanceof TurretTileEnt) {
                    ((TurretTileEnt)tile).setMountedTurret(this);
                    this.mountedTileEnt = (TurretTileEnt)tile;
                    this.mountedTileEnt.needUpdate();
                    this.setCombatTask();
                } else {
                    this.func_70097_a(DamageSource.field_76380_i, 1.0f);
                }
            } else if (this.mountedTileEnt.mountedTurret != this) {
                this.func_70106_y();
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        if (this.func_184614_ca() == ItemStack.field_190927_a) {
            return;
        }
        Item gun = this.func_184614_ca().func_77973_b();
        if (gun instanceof GenericGun && this.mountedTileEnt != null && this.mountedTileEnt.consumeAmmo()) {
            ((GenericGun)gun).fireWeaponFromNPC((EntityLivingBase)this, 1.0f, 1.0f);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void destroy() {
        this.func_70606_j(0.0f);
        this.func_70106_y();
    }

    public void setAITasks() {
        if (this.aiWatch == null) {
            this.aiWatch = new TurretEntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 80.0f, 20.0);
        }
        if (this.aiIdle == null) {
            this.aiIdle = new EntityAILookIdle((EntityLiving)this);
        }
        if (this.aiHurt == null) {
            this.aiHurt = new EntityAIHurtByTargetTGFactions(this, false);
        }
        if (this.aiTarget == null) {
            this.aiTarget = new TurretEntityAINearestAttackableTarget<EntityLivingBase>(this, EntityLivingBase.class, 0, true, false, new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase entity) {
                    if (entity instanceof IMob) {
                        return true;
                    }
                    if (NPCTurret.this.mountedTileEnt != null) {
                        byte pvp = NPCTurret.this.mountedTileEnt.getPvpSetting();
                        UUID owner = NPCTurret.this.mountedTileEnt.getOwner();
                        if (pvp != 0 && owner != null) {
                            UUID ply;
                            if (entity instanceof NPCTurret) {
                                NPCTurret otherTurret = (NPCTurret)entity;
                                if (otherTurret.mountedTileEnt != null) {
                                    UUID otherOwner = otherTurret.mountedTileEnt.getOwner();
                                    return TGNpcFactions.shouldAttack(owner, otherOwner, NPCTurret.this.mountedTileEnt.getPvpSetting());
                                }
                            } else if (entity instanceof EntityPlayer && (ply = ((EntityPlayer)entity).func_146103_bH().getId()) != null) {
                                if (owner.equals(ply)) {
                                    return false;
                                }
                                return TGNpcFactions.shouldAttack(owner, ply, NPCTurret.this.mountedTileEnt.getPvpSetting());
                            }
                        }
                        if (NPCTurret.this.mountedTileEnt.attackAnimals && entity instanceof IAnimals && !(entity instanceof NPCTurret)) {
                            if (entity instanceof EntityTameable) {
                                return !((EntityTameable)entity).func_70909_n();
                            }
                            if (entity instanceof EntityHorse) {
                                return !((EntityHorse)entity).func_110248_bS();
                            }
                            if (entity instanceof IEntityOwnable) {
                                return ((IEntityOwnable)entity).func_70902_q() == null;
                            }
                            return true;
                        }
                    }
                    if (entity instanceof NPCTurret) {
                        return false;
                    }
                    if (entity instanceof EntityPlayer) {
                        return false;
                    }
                    return false;
                }
            }, 20.0);
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiWatch);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiIdle);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiHurt);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiTarget);
    }

    public void disable() {
        this.active = false;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiIdle);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurt);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.aiTarget);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiRangedAttack);
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiRangedAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack != null && itemstack.func_77973_b() instanceof GenericGun) {
            GenericGun gun = (GenericGun)itemstack.func_77973_b();
            this.aiRangedAttack = gun.getAIAttack(this);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiRangedAttack);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)gun.getAI_attackRange());
        }
    }

    public int func_70658_aO() {
        if (this.mountedTileEnt != null) {
            return this.mountedTileEnt.getTurretArmorValue();
        }
        return 0;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        NBTTagCompound tags = super.func_189511_e(compound);
        tags.func_74774_a("turretFacing", (byte)this.turretFacing.func_176745_a());
        return tags;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.turretFacing = EnumFacing.func_82600_a((int)compound.func_74771_c("turretFacing"));
    }

    @Override
    public float getWeaponPosX() {
        return 0.05f;
    }

    @Override
    public float getWeaponPosY() {
        return 0.7f;
    }

    @Override
    public float getWeaponPosZ() {
        return 0.8f;
    }

    @Override
    public TGNpcFaction getTGFaction() {
        return TGNpcFaction.TURRET;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public EnumFacing getTurretFacing() {
        return this.turretFacing;
    }

    public void setTurretFacing(EnumFacing turretFacing) {
        this.turretFacing = turretFacing;
    }
}

