/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import techguns.api.damagesystem.DamageType;
import techguns.client.ClientProxy;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.items.guns.ammo.DamageModifier;

public class GenericProjectileIncendiary
extends GenericProjectile {
    protected boolean showFireTrail = false;

    public GenericProjectileIncendiary(World worldIn) {
        super(worldIn);
    }

    public GenericProjectileIncendiary(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, boolean fireTrail) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        this.showFireTrail = fireTrail;
    }

    public GenericProjectileIncendiary(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, boolean fireTrail) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        this.showFireTrail = fireTrail;
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeFireDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.DEFAULT);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResultIn) {
        super.onHitEffect(ent, rayTraceResultIn);
        if (!ent.func_70045_F()) {
            ent.func_70015_d(3);
        }
    }

    @Override
    protected void hitBlock(RayTraceResult raytraceResultIn) {
        if (this.blockdamage) {
            GenericProjectileIncendiary.burnBlocks(this.field_70170_p, raytraceResultIn, this.damage / 40.0f);
        }
        super.hitBlock(raytraceResultIn);
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        double x = rayTraceResult.field_72307_f.field_72450_a;
        double y = rayTraceResult.field_72307_f.field_72448_b;
        double z = rayTraceResult.field_72307_f.field_72449_c;
        boolean distdelay = true;
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (rayTraceResult.field_178784_b == EnumFacing.UP) {
                pitch = -90.0f;
            } else if (rayTraceResult.field_178784_b == EnumFacing.DOWN) {
                pitch = 90.0f;
            } else {
                yaw = rayTraceResult.field_178784_b.func_185119_l();
            }
        } else {
            pitch = -this.field_70125_A;
            yaw = -this.field_70177_z;
        }
        if (this.showFireTrail) {
            this.sendImpactFX(x, y, z, pitch, yaw, 5, true);
        } else {
            int type = -1;
            if (sound == SoundType.field_185851_d) {
                type = 0;
            } else if (sound == SoundType.field_185848_a || sound == SoundType.field_185857_j) {
                type = 1;
            } else if (sound == SoundType.field_185853_f) {
                type = 2;
            } else if (sound == SoundType.field_185852_e || sound == SoundType.field_185858_k) {
                type = 3;
            } else if (sound == SoundType.field_185849_b || sound == SoundType.field_185855_h) {
                type = 4;
            }
            this.sendImpactFX(x, y, z, pitch, yaw, type, true);
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.showFireTrail);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.showFireTrail = additionalData.readBoolean();
        if (this.showFireTrail) {
            ClientProxy.get().createFXOnEntity("IncendiaryShotgunTrail", this);
        }
    }

    public static class Factory
    implements IProjectileFactory<GenericProjectile> {
        protected DamageModifier mod = new DamageModifier().setDmg(1.1f, 0.0f);
        protected boolean fireTrail;

        public Factory(boolean fireTrail) {
            this.fireTrail = fireTrail;
        }

        @Override
        public DamageModifier getDamageModifier() {
            return this.mod;
        }

        @Override
        public GenericProjectileIncendiary createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new GenericProjectileIncendiary(world, p, this.mod.getDamage(damage), speed, TTL, spread, dmgDropStart, dmgDropEnd, this.mod.getDamage(dmgMin), penetration, blockdamage, firePos, this.fireTrail);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.FIRE;
        }
    }
}

