/*
 * Decompiled with CFR 0.152.
 */
package techguns.items;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import techguns.items.GenericItem;
import techguns.util.BlockPosInd;
import techguns.util.MBlock;

public class BuildingScanTool
extends GenericItem {
    public BuildingScanTool(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack item = player.func_184586_b(hand);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (item.func_77978_p().func_74764_b("x1") && item.func_77978_p().func_74764_b("y1") && item.func_77978_p().func_74764_b("z1")) {
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Position2 set (" + x + "/" + y + "/" + z + ")."));
            }
            int x1 = item.func_77978_p().func_74762_e("x1");
            int y1 = item.func_77978_p().func_74762_e("y1");
            int z1 = item.func_77978_p().func_74762_e("z1");
            int sizeX = Math.abs(x1 - x) + 1;
            int sizeY = Math.abs(y1 - y) + 1;
            int sizeZ = Math.abs(z1 - z) + 1;
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Size: (" + sizeX + "/" + sizeY + "/" + sizeZ + ")."));
            }
            if (!world.field_72995_K) {
                this.scanStructure(world, Math.min(x, x1), Math.min(y, y1), Math.min(z, z1), sizeX, sizeY, sizeZ);
            }
            item.func_77978_p().func_82580_o("x1");
            item.func_77978_p().func_82580_o("y1");
            item.func_77978_p().func_82580_o("z1");
        } else {
            item.func_77978_p().func_74768_a("x1", x);
            item.func_77978_p().func_74768_a("y1", y);
            item.func_77978_p().func_74768_a("z1", z);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Position1 set (" + x + "/" + y + "/" + z + ")."));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void scanStructure(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        StringBuilder sbDefBlocks = new StringBuilder();
        StringBuilder sbIndices = new StringBuilder();
        ArrayList<MBlock> blockList = new ArrayList<MBlock>();
        ArrayList<BlockPosInd> blockPosList = new ArrayList<BlockPosInd>();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int ix = 0; ix < sizeX; ++ix) {
            for (int iy = 0; iy < sizeY; ++iy) {
                for (int iz = 0; iz < sizeZ; ++iz) {
                    int coordX = x + ix;
                    int coordY = y + iy;
                    int coordZ = z + iz;
                    IBlockState bs = world.func_180495_p((BlockPos)p.func_181079_c(coordX, coordY, coordZ));
                    Block b = bs.func_177230_c();
                    if (bs == Blocks.field_150350_a.func_176223_P() || bs == Blocks.field_150346_d.func_176223_P() || bs == Blocks.field_150349_c.func_176223_P()) continue;
                    MBlock mblock = new MBlock(bs);
                    if (!blockList.contains(mblock)) {
                        blockList.add(mblock);
                        sbDefBlocks.append("blockList.add(new MBlock(\"" + mblock.block.getRegistryName() + "\", " + mblock.meta + "));\n");
                    }
                    blockPosList.add(new BlockPosInd(ix, iy, iz, blockList.indexOf(mblock)));
                }
            }
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(new File("structure_scan.txt")));
            pw.println(sbDefBlocks.toString());
            pw.println("---");
            pw.println();
            pw.println(blockPosList.size());
            for (int i = 0; i < blockPosList.size(); ++i) {
                BlockPosInd bp = (BlockPosInd)((Object)blockPosList.get(i));
                pw.println(bp.toString());
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

