/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.api.guns.GunHandType;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.ClientProxy;
import techguns.client.ShooterValues;
import techguns.client.audio.TGSoundCategory;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.items.guns.ChargedProjectileSelector;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticleOnEntity;
import techguns.util.EntityCondition;
import techguns.util.InventoryUtil;
import techguns.util.SoundUtil;

public class GenericGunCharge
extends GenericGun {
    public float fullChargeTime = 20.0f;
    public int ammoConsumedOnFullCharge = 10;
    protected ChargedProjectileSelector chargedProjectile_selector;
    public boolean hasChargedFireAnim = true;
    public boolean canFireWhileCharging = false;
    SoundEvent startChargeSound = null;
    String chargeFX = null;
    private float chargeFXoffsetX = 0.0f;
    private float chargeFXoffsetY = 0.0f;
    private float chargeFXoffsetZ = 0.0f;

    public GenericGunCharge(String name, ChargedProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy, float fullChargeTime, int ammoConsumedOnFullCharge) {
        super(name, projectile_selector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy);
        this.fullChargeTime = fullChargeTime;
        this.ammoConsumedOnFullCharge = ammoConsumedOnFullCharge;
        this.chargedProjectile_selector = projectile_selector;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        TGExtendedPlayer extendedPlayer = TGExtendedPlayer.get(player);
        ItemStack item = player.func_184586_b(handIn);
        World world = player.func_130014_f_();
        if (this.canZoom && player.func_70093_af() && this.toggleZoom) {
            if (world.field_72995_K) {
                ClientProxy cp = ClientProxy.get();
                cp.player_zoom = cp.player_zoom != 1.0f ? 1.0f : this.zoomMult;
            }
        } else {
            int ammo = this.getCurrentAmmo(item);
            if (ammo > 0) {
                int firedelay = extendedPlayer.getFireDelay(handIn);
                if (firedelay <= 0) {
                    extendedPlayer.setFireDelay(handIn, this.minFiretime);
                    player.func_184598_c(handIn);
                    this.startCharge(item, world, player);
                    TGExtendedPlayer txp = TGExtendedPlayer.get(player);
                    txp.setChargingWeapon(true);
                    if (this.startChargeSound != null) {
                        SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.startChargeSound, 4.0f, 1.0f, false, true, false, TGSoundCategory.GUN_FIRE, EntityCondition.CHARGING_WEAPON);
                    }
                    if (this.chargeFX != null) {
                        float x = player.func_184591_cq() == EnumHandSide.RIGHT ? this.chargeFXoffsetX : -this.chargeFXoffsetX;
                        TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticleOnEntity(this.chargeFX, (Entity)player, x, this.chargeFXoffsetY, this.chargeFXoffsetZ, true, EntityCondition.CHARGING_WEAPON), TGPackets.targetPointAroundEnt((Entity)player, 25.0));
                    }
                }
            } else if (InventoryUtil.consumeAmmoPlayer(player, this.ammoType.getAmmo(this.getCurrentAmmoVariant(item)))) {
                Arrays.stream(this.ammoType.getEmptyMag()).forEach(e -> {
                    int amount;
                    if (!e.func_190926_b() && (amount = InventoryUtil.addAmmoToPlayerInventory(player, TGItems.newStack(e, 1))) > 0 && !world.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(e, amount)));
                    }
                });
                if (world.field_72995_K && this.canZoom && this.toggleZoom) {
                    ClientProxy cp = ClientProxy.get();
                    if (cp.player_zoom != 1.0f) {
                        cp.player_zoom = 1.0f;
                    }
                }
                extendedPlayer.setFireDelay(handIn, this.reloadtime - this.minFiretime);
                if (this.ammoCount > 1) {
                    int i;
                    for (i = 1; i < this.ammoCount && InventoryUtil.consumeAmmoPlayer(player, this.ammoType.getAmmo(this.getCurrentAmmoVariant(item))); ++i) {
                    }
                    this.reloadAmmo(item, i);
                } else {
                    this.reloadAmmo(item);
                }
                SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.reloadsound, 1.0f, 1.0f, false, true, TGSoundCategory.RELOAD);
                if (world.field_72995_K) {
                    int time = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                    ShooterValues.setReloadtime((EntityLivingBase)player, handIn == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)time, time, (byte)1);
                    this.client_startReload();
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)item);
    }

    protected void startCharge(ItemStack item, World world, EntityPlayer player) {
    }

    @Override
    public void shootGunPrimary(ItemStack stack, World world, EntityPlayer player, boolean zooming, EnumHand hand, Entity target) {
        if (this.canFireWhileCharging || player.func_184607_cu() != stack) {
            super.shootGunPrimary(stack, world, player, zooming, hand, target);
        }
    }

    public void func_77615_a(ItemStack item, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            int ammoConsumed;
            EntityPlayer player = (EntityPlayer)entityLiving;
            TGExtendedPlayer txp = TGExtendedPlayer.get(player);
            txp.setChargingWeapon(false);
            int j = this.func_77626_a(item) - timeLeft;
            float f = (float)j / this.fullChargeTime;
            if (f > 1.0f) {
                f = 1.0f;
            }
            if ((ammoConsumed = this.consumeAmmoCharge(item, f, player.field_71075_bZ.field_75098_d)) < (int)Math.ceil(f * (float)this.ammoConsumedOnFullCharge)) {
                f = (float)ammoConsumed / (float)this.ammoConsumedOnFullCharge;
            }
            if (!world.field_72995_K) {
                EnumBulletFirePos firePos = player.func_184591_cq() == EnumHandSide.RIGHT ? EnumBulletFirePos.RIGHT : EnumBulletFirePos.LEFT;
                this.spawnChargedProjectile(world, (EntityLivingBase)player, item, this.accuracy, f, ammoConsumed, firePos);
                if (this.shotgun) {
                    for (int i = 0; i < this.bulletcount; ++i) {
                        this.spawnChargedProjectile(world, (EntityLivingBase)player, item, this.spread, f, ammoConsumed, firePos);
                    }
                }
                if (this.hasChargedFireAnim) {
                    this.playChargedFiresound(item, world, player, f);
                }
            } else {
                if (this.hasChargedFireAnim) {
                    int recoiltime_l = this.getRecoilTime(f);
                    int muzzleFlashtime_l = this.getMuzzleFlashTime(f);
                    ShooterValues.setRecoiltime((EntityLivingBase)player, player.func_184600_cs() == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)recoiltime_l, recoiltime_l, (byte)1, f);
                    ShooterValues.setMuzzleFlashTime((EntityLivingBase)player, player.func_184600_cs() == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)muzzleFlashtime_l, muzzleFlashtime_l);
                }
                this.client_weaponFired();
            }
        }
    }

    protected void playChargedFiresound(ItemStack item, World world, EntityPlayer player, float chargeProgress) {
        SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.firesound, 4.0f, 1.0f, false, false, true, TGSoundCategory.GUN_FIRE);
        if (this.rechamberSound != null) {
            SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.rechamberSound, 1.0f, 1.0f, false, false, true, TGSoundCategory.GUN_FIRE);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 288000;
    }

    public int getRecoilTime(float charge) {
        return (int)((float)this.recoiltime / 20.0f * 1000.0f);
    }

    public int getMuzzleFlashTime(float charge) {
        return (int)((float)this.muzzleFlashtime / 20.0f * 1000.0f);
    }

    public int consumeAmmoCharge(ItemStack item, float f, boolean creative) {
        int amount = (int)Math.ceil(f * (float)this.ammoConsumedOnFullCharge);
        if (!creative) {
            amount = this.useAmmo(item, amount);
        }
        return amount;
    }

    public void spawnChargedProjectile(World world, EntityLivingBase player, ItemStack itemStack, float spread, float charge, int ammoConsumed, EnumBulletFirePos firePos) {
        IProjectileFactory fact = this.chargedProjectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(itemStack));
        Object proj = fact.createChargedProjectile(world, player, this.damage, this.speed, this.getScaledTTL(), spread, this.damageDropStart, this.damageDropEnd, this.damageMin, this.penetration, GenericGunCharge.getDoBlockDamage(player), firePos, this.radius, this.gravity, charge, ammoConsumed);
        if (proj != null) {
            world.func_72838_d(proj);
        }
    }

    @Override
    public boolean canCharge() {
        return true;
    }

    public GenericGunCharge setChargeFireAnims(boolean hasAnims) {
        this.hasChargedFireAnim = hasAnims;
        return this;
    }

    public GenericGunCharge setFireWhileCharging(boolean canFire) {
        this.canFireWhileCharging = canFire;
        return this;
    }

    @Override
    public boolean hasRightClickAction() {
        return this.getGunHandType() == GunHandType.TWO_HANDED;
    }

    public GenericGunCharge setChargeSound(SoundEvent startChargeSound) {
        this.startChargeSound = startChargeSound;
        return this;
    }

    public GenericGunCharge setChargeFX(String fx, float offsetX, float offsetY, float offsetZ) {
        this.chargeFX = fx;
        this.chargeFXoffsetX = offsetX;
        this.chargeFXoffsetY = offsetY;
        this.chargeFXoffsetZ = offsetZ;
        return this;
    }
}

