/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.damagesystem.DamageType;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.ShooterValues;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.items.guns.ChargedProjectileSelector;
import techguns.items.guns.GenericGunCharge;
import techguns.items.guns.IGenericGunMelee;
import techguns.packets.PacketPlaySound;
import techguns.plugins.crafttweaker.EnumGunStat;
import techguns.util.BlockUtils;
import techguns.util.ItemUtil;
import techguns.util.TextUtil;

public class GenericGunMeleeCharge
extends GenericGunCharge
implements IGenericGunMelee<GenericGunMeleeCharge> {
    HashMap<String, Integer> mininglevels = new HashMap();
    protected int miningRadius = 0;
    protected int swingSoundDelay = 5;
    protected ItemStack[] miningHeads = null;
    protected boolean hasCustomAnim = true;
    protected float melee_sound_volume = 0.65f;

    public GenericGunMeleeCharge(String name, ChargedProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy, float fullChargeTime, int ammoConsumedOnFullCharge) {
        super(name, projectile_selector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy, fullChargeTime, ammoConsumedOnFullCharge);
    }

    public GenericGunMeleeCharge setMiningHeads(ItemStack ... heads) {
        this.miningHeads = heads;
        return this;
    }

    public GenericGunMeleeCharge setMiningRadius(int miningRadius) {
        this.miningRadius = miningRadius;
        return this;
    }

    public GenericGunMeleeCharge setSwingSoundDelay(int swingSoundDelay) {
        this.swingSoundDelay = swingSoundDelay;
        return this;
    }

    public GenericGunMeleeCharge setHasCustomAnim(boolean customAnim) {
        this.hasCustomAnim = customAnim;
        return this;
    }

    public int getMiningRadius(ItemStack stack) {
        return this.miningRadius + this.getExtraMiningRadius(stack);
    }

    @Override
    public HashMap<String, Integer> getMiningLevels() {
        return this.mininglevels;
    }

    public int getExtraMiningRadius(ItemStack stack) {
        return 0;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.getDigSpeed(stack, state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return this.getToolHarvestLevel(stack, toolClass, player, blockState);
    }

    @Override
    public float getEffectiveDigSpeed(ItemStack itemstack) {
        return this.digSpeed + this.getExtraDigSpeed(itemstack);
    }

    @Override
    public int getMiningAmmoConsumption() {
        return this.miningAmmoConsumption;
    }

    @Override
    public GenericGunMeleeCharge setDigSpeed(float speed) {
        this.digSpeed = speed;
        return this;
    }

    @Override
    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        if (this.getCurrentAmmo(stack) > 0) {
            src.goreChance = 1.0f;
            src.armorPenetration = this.penetration;
            src.knockbackMultiplier = 1.0f;
        } else {
            src.deathType = EntityDeathUtils.DeathType.DEFAULT;
        }
        return src;
    }

    protected SoundEvent getSwingSound() {
        return TGSounds.POWERHAMMER_SWING;
    }

    protected SoundEvent getBlockBreakSound() {
        return TGSounds.POWERHAMMER_IMPACT;
    }

    @Override
    protected void addInitialTags(NBTTagCompound tags) {
        super.addInitialTags(tags);
        tags.func_74768_a("miningHead", 0);
    }

    public int getMiningHeadLevel(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            this.func_77622_d(stack, null, null);
        }
        return tags.func_74762_e("miningHead");
    }

    public int getMiningHeadLevelForHead(ItemStack head) {
        if (this.miningHeads != null) {
            for (int i = 0; i < this.miningHeads.length; ++i) {
                if (!ItemUtil.isItemEqual(this.miningHeads[i], head)) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public String getCurrentMiningHeadForTooltip(ItemStack stack) {
        if (this.miningHeads != null && this.getMiningHeadLevel(stack) > 0) {
            return this.miningHeads[this.getMiningHeadLevel(stack) - 1].func_77977_a() + ".name";
        }
        return "techguns.default";
    }

    @Override
    public int getExtraMiningLevel(ItemStack stack, String toolClass, EntityPlayer player) {
        return this.getMiningHeadLevel(stack);
    }

    public float getExtraDigSpeed(ItemStack stack) {
        int headlevel = this.getMiningHeadLevel(stack);
        return 1.0f * (float)headlevel;
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        boolean openingContainer = false;
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer ply = (EntityPlayer)entityLiving;
            if (ply.field_71070_bA != null && ply.field_71070_bA.getClass() != ContainerPlayer.class) {
                openingContainer = true;
            }
        }
        if (this.getCurrentAmmo(stack) > 0) {
            if (entityLiving.field_70170_p.field_72995_K) {
                if (ShooterValues.getRecoiltime(entityLiving, false) < System.currentTimeMillis()) {
                    ShooterValues.setRecoiltime(entityLiving, false, System.currentTimeMillis() + 250L, 250, (byte)0);
                }
                return this.hasCustomAnim;
            }
            boolean sendSound = true;
            if (entityLiving instanceof EntityPlayer) {
                TGExtendedPlayer props = TGExtendedPlayer.get((EntityPlayer)entityLiving);
                if (props.swingSoundDelay > 0) {
                    sendSound = false;
                } else {
                    props.swingSoundDelay = this.swingSoundDelay;
                }
            }
            if (!openingContainer && sendSound) {
                TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(this.getSwingSound(), (Entity)entityLiving, this.melee_sound_volume, 1.0f, false, false, true, true, TGSoundCategory.GUN_FIRE), TGPackets.targetPointAroundEnt((Entity)entityLiving, 32.0));
            }
            return this.hasCustomAnim;
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (this.getCurrentAmmo(stack) > 0) {
            SoundEvent sound;
            this.useAmmo(stack, 1);
            if (entityLiving instanceof EntityPlayer && (sound = this.getBlockBreakSound()) != null) {
                worldIn.func_184148_a((EntityPlayer)entityLiving, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound, SoundCategory.PLAYERS, this.melee_sound_volume, 1.0f);
            }
            return true;
        }
        return false;
    }

    public EnumFacing getSideHitMining(World world, EntityPlayer player) {
        RayTraceResult result = this.func_77621_a(world, player, false);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            return result.field_178784_b;
        }
        return null;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double meleedmg = this.meleeDamagePwr;
            int ammoleft = this.getCurrentAmmo(stack);
            if (ammoleft <= 0) {
                meleedmg = this.meleeDamageEmpty;
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", meleedmg, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    @Override
    protected void addMiningTooltip(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn, boolean longTooltip) {
        super.addMiningTooltip(stack, world, list, flagIn, longTooltip);
        if (longTooltip) {
            if (this.miningHeads != null) {
                list.add(TextUtil.trans("techguns.tooltip.mininghead") + ": " + ChatFormatting.WHITE + TextUtil.trans(this.getCurrentMiningHeadForTooltip(stack)));
            }
            list.add(TextUtil.trans("techguns.tooltip.toolclasses") + ":");
            for (String s : this.getMiningLevels().keySet()) {
                if (s.equals("default")) continue;
                list.add(" " + TextUtil.transTG("toolclass." + s) + ": " + (this.getMiningLevels().get(s) + this.getExtraMiningLevel(stack, s, null)));
            }
            list.add(TextUtil.trans("techguns.tooltip.breakspeed") + ": " + this.getEffectiveDigSpeed(stack));
            int r = this.getMiningRadius(stack) * 2 + 1;
            list.add(TextUtil.trans("techguns.tooltip.miningradius") + ": " + r + "x" + r);
        } else {
            String toolclasses = null;
            for (String s : this.getMiningLevels().keySet()) {
                if (s.equals("default")) continue;
                if (toolclasses != null) {
                    toolclasses = toolclasses + ", " + s;
                    continue;
                }
                toolclasses = s;
            }
            if (toolclasses != null) {
                list.add(TextUtil.trans("techguns.tooltip.toolclasses") + ": " + toolclasses);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        EnumFacing sideHit;
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af() && this.getMiningRadius(itemstack) > 0 && (sideHit = this.getSideHitMining(player.field_70170_p, player)) != null) {
            World w = player.field_70170_p;
            List<BlockPos> otherblocks = BlockUtils.getBlockPlaneAroundAxisForMining(player.field_70170_p, player, pos, sideHit.func_176740_k(), this.getMiningRadius(itemstack), false, this, itemstack);
            otherblocks.forEach(b -> {
                IBlockState state;
                if (w.func_175667_e(b) && (state = w.func_180495_p(b)).func_177230_c() != null && state.func_177230_c() != Blocks.field_150350_a && state.func_185903_a(player, w, b) > 0.0f && state.func_177230_c().canHarvestBlock((IBlockAccess)w, b, player) && this.isEffectiveToolForState(itemstack, state)) {
                    EntityPlayerMP plyMP = (EntityPlayerMP)player;
                    int xpAmount = ForgeHooks.onBlockBreakEvent((World)w, (GameType)plyMP.field_71134_c.func_73081_b(), (EntityPlayerMP)plyMP, (BlockPos)b);
                    if (xpAmount >= 0) {
                        Block block = state.func_177230_c();
                        block.func_176208_a(w, b, state, player);
                        TileEntity tile = w.func_175625_s(b);
                        if (block.removedByPlayer(state, w, b, player, true)) {
                            block.func_176206_d(w, b, state);
                            if (!player.field_71075_bZ.field_75098_d) {
                                block.func_180657_a(w, player, pos, state, tile, itemstack);
                                block.func_180637_b(w, b, xpAmount);
                            }
                            w.func_175718_b(2001, b, Block.func_176210_f((IBlockState)state));
                            plyMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(w, b));
                        }
                    }
                }
            });
        }
        return false;
    }

    @Override
    public boolean setGunStat(EnumGunStat stat, float value) {
        if (super.setGunStat(stat, value)) {
            return true;
        }
        switch (stat) {
            case MINING_SPEED: {
                this.digSpeed = value;
                return true;
            }
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.isEffectiveToolForState(stack, state);
    }
}

