/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.client.ClientProxy;
import techguns.util.EntityCondition;
import techguns.util.TGLogger;

public class PacketSpawnParticleOnEntity
implements IMessage {
    String name;
    int entityID;
    float offsetX = 0.0f;
    float offsetY = 0.0f;
    float offsetZ = 0.0f;
    boolean attachToHead = false;
    EntityCondition condition;

    public PacketSpawnParticleOnEntity() {
    }

    public PacketSpawnParticleOnEntity(String name, Entity ent) {
        this(name, ent, 0.0f, 0.0f, 0.0f, false, EntityCondition.NONE);
    }

    public PacketSpawnParticleOnEntity(String name, Entity ent, float offsetX, float offsetY, float offsetZ, boolean attachToHead) {
        this(name, ent, offsetX, offsetY, offsetZ, attachToHead, EntityCondition.NONE);
    }

    public PacketSpawnParticleOnEntity(String name, Entity ent, float offsetX, float offsetY, float offsetZ, boolean attachToHead, EntityCondition condition) {
        this.name = name;
        this.entityID = ent.func_145782_y();
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.attachToHead = attachToHead;
        this.condition = condition;
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        this.name = buf.readCharSequence((int)len, StandardCharsets.UTF_8).toString();
        this.entityID = buf.readInt();
        this.offsetX = buf.readFloat();
        this.offsetY = buf.readFloat();
        this.offsetZ = buf.readFloat();
        this.attachToHead = buf.readBoolean();
        this.condition = EntityCondition.fromByte(buf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        String cs = this.name;
        buf.writeShort(cs.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        buf.writeInt(this.entityID);
        buf.writeFloat(this.offsetX);
        buf.writeFloat(this.offsetY);
        buf.writeFloat(this.offsetZ);
        buf.writeBoolean(this.attachToHead);
        if (this.condition == null) {
            buf.writeByte((int)EntityCondition.NONE.id);
        } else {
            buf.writeByte((int)this.condition.id);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticleOnEntity, IMessage> {
        public IMessage onMessage(PacketSpawnParticleOnEntity message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSpawnParticleOnEntity m, MessageContext ctx) {
            Entity ent = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(m.entityID);
            if (ent != null) {
                ClientProxy.get().createFXOnEntityWithOffset(m.name, ent, m.offsetX, m.offsetY, m.offsetZ, m.attachToHead, m.condition);
            } else {
                TGLogger.logger_client.warning("Got Packet for FX " + m.name + " on Entity, but ent was null");
            }
        }
    }
}

