/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.packets.HandlerTemplate;
import techguns.tileentities.operation.ITileEntityFluidTanks;

public class PacketUpdateTileEntTanks
implements IMessage {
    int tileX;
    int tileY;
    int tileZ;
    NBTTagCompound tankTags;

    public PacketUpdateTileEntTanks(ITileEntityFluidTanks tile, BlockPos pos) {
        this.tankTags = new NBTTagCompound();
        tile.saveTanksToNBT(this.tankTags);
        this.tileX = pos.func_177958_n();
        this.tileY = pos.func_177956_o();
        this.tileZ = pos.func_177952_p();
    }

    public PacketUpdateTileEntTanks() {
    }

    public void fromBytes(ByteBuf buf) {
        this.tileX = buf.readInt();
        this.tileY = buf.readInt();
        this.tileZ = buf.readInt();
        this.tankTags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tileX);
        buf.writeInt(this.tileY);
        buf.writeInt(this.tileZ);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tankTags);
    }

    public static class Handler
    extends HandlerTemplate<PacketUpdateTileEntTanks> {
        @Override
        protected void handle(PacketUpdateTileEntTanks m, MessageContext ctx) {
            BlockPos p;
            TileEntity tile;
            if (m.tankTags != null && (tile = TGPackets.getPlayerFromContext((MessageContext)ctx).field_70170_p.func_175625_s(p = new BlockPos(m.tileX, m.tileY, m.tileZ))) != null && tile instanceof ITileEntityFluidTanks) {
                ((ITileEntityFluidTanks)tile).loadTanksFromNBT(m.tankTags);
            }
        }
    }
}

