/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import techguns.gui.TGBaseGui;
import techguns.tileentities.operation.IMachineRecipe;
import techguns.util.TextUtil;

public abstract class BasicRecipeWrapper
implements IRecipeWrapper {
    public IMachineRecipe recipe;

    public BasicRecipeWrapper(IMachineRecipe recipe) {
        this.recipe = recipe;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (TGBaseGui.isInRect(mouseX, mouseY, 0, 1, 6, 60)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.container.power") + ":");
            tooltip.add("-" + this.getRFperTick() + " " + "FE" + "/t");
            tooltip.add("-" + this.getRFperTick() * this.getDuration() + " " + "FE");
            return tooltip;
        }
        return Collections.emptyList();
    }

    protected int getDuration() {
        return 100;
    }

    protected abstract int getRFperTick();

    public void getIngredients(IIngredients ingredients) {
        List<List<FluidStack>> fluidsOut;
        List<List<ItemStack>> outputs;
        List<List<FluidStack>> fluidsIn;
        List<List<ItemStack>> inputs = this.recipe.getItemInputs();
        if (inputs != null && !inputs.isEmpty()) {
            ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        }
        if ((fluidsIn = this.recipe.getFluidInputs()) != null && !fluidsIn.isEmpty()) {
            ingredients.setInputLists(VanillaTypes.FLUID, fluidsIn);
        }
        if ((outputs = this.recipe.getItemOutputs()) != null && !outputs.isEmpty()) {
            ingredients.setOutputLists(VanillaTypes.ITEM, outputs);
        }
        if ((fluidsOut = this.recipe.getFluidOutputs()) != null && !fluidsOut.isEmpty()) {
            ingredients.setOutputLists(VanillaTypes.FLUID, fluidsOut);
        }
    }
}

