/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import techguns.gui.TGBaseGui;
import techguns.plugins.jei.BasicRecipeWrapper;
import techguns.tileentities.operation.ChargingStationRecipe;
import techguns.util.TextUtil;

public class ChargingStationJeiRecipe
extends BasicRecipeWrapper {
    ChargingStationRecipe rec;

    public ChargingStationJeiRecipe(ChargingStationRecipe recipe) {
        super(recipe);
        this.rec = recipe;
    }

    @Override
    protected int getRFperTick() {
        return 800;
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (TGBaseGui.isInRect(mouseX, mouseY, 0, 1, 6, 60)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.container.power") + ":");
            double duration = (double)this.rec.chargeAmount / (double)this.getRFperTick();
            tooltip.add("-" + this.getRFperTick() + " " + "FE" + "/t");
            tooltip.add("-" + this.rec.chargeAmount + " " + "FE");
            tooltip.add(TextUtil.trans("techguns.container.chargingstation.duration") + ": " + String.format("%.2f", duration / 20.0) + "s");
            return tooltip;
        }
        return Collections.emptyList();
    }

    public static List<ChargingStationJeiRecipe> getRecipes(IJeiHelpers helpers) {
        IStackHelper stackHelper = helpers.getStackHelper();
        ArrayList<ChargingStationJeiRecipe> recipes = new ArrayList<ChargingStationJeiRecipe>();
        ChargingStationRecipe.getRecipes().forEach(r -> recipes.add(new ChargingStationJeiRecipe((ChargingStationRecipe)r)));
        return recipes;
    }
}

