/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.ITickTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import techguns.gui.ReactionChamberGui;

public class ProgressBarReactionChamberCompletion
implements IDrawableAnimated {
    protected ITickTimer timer;
    protected IGuiHelper guiHelper;
    protected int w;
    protected int h;
    protected int recipeTicks;
    protected int totalTime;
    protected int guiStepWidth;
    protected int requiredCompletion;

    public ProgressBarReactionChamberCompletion(IGuiHelper guiHelper, int w, int h, int recipeTicks, int reqCompletion) {
        this.guiHelper = guiHelper;
        this.totalTime = recipeTicks * 60;
        this.timer = guiHelper.createTickTimer(this.totalTime, this.totalTime, false);
        this.recipeTicks = recipeTicks;
        this.guiStepWidth = (int)(100.0f / (float)reqCompletion);
        this.requiredCompletion = reqCompletion;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        minecraft.func_110434_K().func_110577_a(ReactionChamberGui.texture);
        int completion_totalTime = this.requiredCompletion * 60;
        float prog = (float)this.timer.getValue() / (float)completion_totalTime;
        if (prog > 1.0f) {
            prog = 1.0f;
        }
        int steps = (int)(prog * (float)completion_totalTime) / (int)((float)completion_totalTime / (float)this.requiredCompletion);
        this.drawTexturedModalRect(xOffset, yOffset, 0, 167, steps * this.guiStepWidth, 4);
    }

    private void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        Gui.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (float)256.0f, (float)256.0f);
    }
}

