/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import techguns.tileentities.BasicOwnedTileEnt;
import techguns.world.dungeon.Dungeon;
import techguns.world.dungeon.DungeonTemplate;
import techguns.world.dungeon.presets.IDungeonPreset;
import techguns.world.dungeon.presets.PresetTemplateTest;

public class DungeonGeneratorTileEnt
extends BasicOwnedTileEnt {
    public static final int BUTTON_ID_GHOST = 2;
    public static final int BUTTON_ID_GENERATE = 3;
    public static final int BUTTON_ID_CLEAR = 9;
    public int sizeX = 48;
    public int sizeY = 26;
    public int sizeZ = 48;
    public boolean showGhost = true;

    public DungeonGeneratorTileEnt() {
        super(0, false);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.dungeongenerator", new Object[0]);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.sizeX = tags.func_74762_e("sizeX");
        this.sizeY = tags.func_74762_e("sizeY");
        this.sizeZ = tags.func_74762_e("sizeZ");
        this.showGhost = tags.func_74767_n("showGhost");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74768_a("sizeX", this.sizeX);
        tags.func_74768_a("sizeY", this.sizeY);
        tags.func_74768_a("sizeZ", this.sizeZ);
        tags.func_74757_a("showGhost", this.showGhost);
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (!this.isUseableByPlayer(ply)) {
            return;
        }
        switch (id) {
            case 2: {
                this.showGhost = !this.showGhost;
                break;
            }
            case 9: {
                this.clearBlocks();
                break;
            }
            case 3: {
                this.generateDungeon(data);
                break;
            }
            default: {
                super.buttonClicked(id, ply, data);
            }
        }
        this.needUpdate();
    }

    private void generateDungeon(String name) {
        Dungeon dungeon = name == null || name.equals("") || name.length() == 0 || !DungeonTemplate.dungeonTemplates.containsKey(name) ? new Dungeon(IDungeonPreset.PRESET_NETHER) : new Dungeon(new PresetTemplateTest(DungeonTemplate.dungeonTemplates.get(name)));
        dungeon.generate(this.field_145850_b, this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, this.sizeX, this.sizeY, this.sizeZ);
    }

    private void clearBlocks() {
        for (int x = 1; x < this.sizeX + 1; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 1; z < this.sizeZ + 1; ++z) {
                    BlockPos bpos = this.field_174879_c.func_177982_a(x, y, z);
                    this.field_145850_b.func_175698_g(bpos);
                }
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(this.sizeX + 1, this.sizeY, this.sizeZ + 1));
    }
}

