/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.entities.npcs.ArmySoldier;
import techguns.entities.npcs.AttackHelicopter;
import techguns.tileentities.TGSpawnerTileEnt;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MathUtil;
import techguns.world.structures.Barracks;
import techguns.world.structures.Bunker;
import techguns.world.structures.CampProps;
import techguns.world.structures.Containers;
import techguns.world.structures.EmptyPlane;
import techguns.world.structures.Helipad;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.Tanks;
import techguns.world.structures.Tent;
import techguns.world.structures.WatchTowerSmall;
import techguns.world.structures.WorldgenStructure;

public class MilitaryCamp {
    static int outerFenceWidth = 1;
    static int outerFenceHeight = 2;
    static int outerFenceSpacing = 1;
    static int outerFenceGateHeight = 2;
    static int roadMaxWidth = 5;
    static int roadMinWidth = 1;
    static MBlock groundBlock = null;
    static ArrayList<WorldgenStructure> structures;
    static ArrayList<WorldgenStructure> borderStructures;
    static ArrayList<WorldgenStructure> cornerStructures;
    static String[] militaryCampSpawns;
    static int minBorderStructureSize;
    static int maxBorderStructureSize;
    static int minCornerStructureSize;
    static int maxCornerStructureSize;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeX;
    public int sizeZ;
    float borderChanceX = 0.0f;
    float borderChanceZ = 0.0f;
    float cornerChance = 0.0f;
    int minSubSegmentSize = 7;
    int maxSubSegmentSize = 15;
    public WorldgenStructure.BiomeColorType colorType = WorldgenStructure.BiomeColorType.WOODLAND;
    Random rand;
    CampSegment rootSegment;
    private int maxHeightDiff = 0;
    CampSegment flagSegment;
    List<Integer> spawnPositions = new ArrayList<Integer>();
    private double campRadiusSquared;

    public MilitaryCamp(int maxHeightDiff, Random rnd) {
        this.maxHeightDiff = maxHeightDiff;
        this.rand = rnd;
    }

    public void init(int posX, int posY, int posZ, int sizeX, int sizeZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.campRadiusSquared = MathUtil.Vec2.substract(new MathUtil.Vec2(this.posX, this.posZ), new MathUtil.Vec2((float)this.posX + (float)this.sizeX / 2.0f, (float)this.posZ + (float)this.sizeZ / 2.0f)).lenSquared();
        int x = posX + outerFenceWidth + outerFenceSpacing;
        int z = posZ + outerFenceWidth + outerFenceSpacing;
        int roadWidth = Math.max(roadMinWidth, Math.min(roadMaxWidth, Math.max(sizeX, sizeZ) / 8));
        this.borderChanceX = (float)(sizeX - minBorderStructureSize) / (float)(maxBorderStructureSize - minBorderStructureSize);
        this.borderChanceZ = (float)(sizeZ - minBorderStructureSize) / (float)(maxBorderStructureSize - minBorderStructureSize);
        this.cornerChance = (float)((sizeX + sizeZ) / 2 - minCornerStructureSize) / (float)(maxCornerStructureSize - minCornerStructureSize);
        this.minSubSegmentSize = Math.min(sizeX, sizeZ) < 10 ? 5 : 7;
        this.maxSubSegmentSize = Math.min(sizeX, sizeZ) <= 45 ? 15 : Math.min(sizeX, sizeZ) / 3;
        this.rootSegment = new CampSegment(x, posY, z, sizeX - 2 * (outerFenceWidth + outerFenceSpacing), sizeZ - 2 * (outerFenceWidth + outerFenceSpacing), roadWidth, 0);
        this.rootSegment.isCenter = true;
        this.rootSegment.splitStep = 0;
        this.rootSegment.generateSubSegments();
    }

    public void setBlocks(World world, Random rnd) {
        int j;
        this.colorType = BlockUtils.getBiomeType(world, this.posX + this.sizeX / 2, this.posZ + this.sizeZ / 2);
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        if (this.maxHeightDiff != -1) {
            BlockUtils.removeJunkInArea(world, this.posX - 1, this.posZ - 1, this.sizeX + 2, this.sizeZ + 2);
            BlockUtils.flattenArea(world, this.posX, this.posZ, this.sizeX, this.sizeZ, this.maxHeightDiff);
            BlockUtils.apply2DHeightmapFilter(world, this.posX - 1, this.posZ - 1, this.sizeX + 2, this.sizeZ + 2, BlockUtils.FILTER_GAUSSIAN_5x5);
        }
        if (this.sizeX < (outerFenceWidth + outerFenceSpacing) * 2 + 1 || this.sizeZ < (outerFenceWidth + outerFenceSpacing) * 2 + 1) {
            return;
        }
        if (groundBlock != null) {
            IBlockState state = groundBlock.getState();
            for (int i = 0; i < this.sizeX; ++i) {
                for (j = 0; j < this.sizeZ; ++j) {
                    if (this.maxHeightDiff != 0) {
                        this.posY = this.getGroundY(world, this.posX + i, this.posZ + j);
                    }
                    world.func_180501_a((BlockPos)p.func_181079_c(this.posX + i, this.posY, this.posZ + j), state, 2);
                }
            }
        }
        IBlockState outerfencestate = MBlockRegister.MILBASE_FENCE.getState();
        for (int k = 1; k < outerFenceHeight + 1; ++k) {
            for (int i = 0; i < this.sizeX; ++i) {
                if (this.maxHeightDiff != 0) {
                    this.posY = this.getGroundY(world, this.posX + i, this.posZ);
                }
                world.func_180501_a((BlockPos)p.func_181079_c(this.posX + i, this.posY + k, this.posZ), outerfencestate, 2);
                if (this.maxHeightDiff != 0) {
                    this.posY = this.getGroundY(world, this.posX + i, this.posZ + this.sizeZ - 1);
                }
                world.func_180501_a((BlockPos)p.func_181079_c(this.posX + i, this.posY + k, this.posZ + this.sizeZ - 1), outerfencestate, 2);
            }
            for (j = 1; j < this.sizeZ - 1; ++j) {
                if (this.maxHeightDiff != 0) {
                    this.posY = this.getGroundY(world, this.posX, this.posZ + j);
                }
                world.func_180501_a((BlockPos)p.func_181079_c(this.posX, this.posY + k, this.posZ + j), outerfencestate, 2);
                if (this.maxHeightDiff != 0) {
                    this.posY = this.getGroundY(world, this.posX + this.sizeX - 1, this.posZ + j);
                }
                world.func_180501_a((BlockPos)p.func_181079_c(this.posX + this.sizeX - 1, this.posY + k, this.posZ + j), outerfencestate, 2);
            }
        }
        this.rootSegment.setBlocks(world, rnd);
        this.initCampFlagEntity(world);
    }

    private void initCampFlagEntity(World world) {
        if (this.flagSegment == null) {
            return;
        }
        BlockUtils.flattenArea(world, this.flagSegment.x, this.flagSegment.z, this.flagSegment.sizeX, this.flagSegment.sizeZ, 0);
        int posX = this.flagSegment.x + this.flagSegment.sizeX / 2;
        int posZ = this.flagSegment.z + this.flagSegment.sizeZ / 2;
        int posY = this.getGroundY(world, posX, posZ) + 1;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(posX, posY, posZ);
        world.func_180501_a((BlockPos)p, TGBlocks.MONSTER_SPAWNER.func_176223_P().func_177226_a((IProperty)TGBlocks.MONSTER_SPAWNER.TYPE, (Comparable)((Object)EnumMonsterSpawnerType.SOLDIER_SPAWN)), 3);
        TileEntity tile = world.func_175625_s((BlockPos)p);
        if (tile != null && tile instanceof TGSpawnerTileEnt) {
            TGSpawnerTileEnt spawner = (TGSpawnerTileEnt)tile;
            spawner.addMobType(AttackHelicopter.class, 1);
            spawner.setParams(1, 1, 200, 0);
            int h = Math.min(posY + 64, world.func_72940_L()) - posY;
            spawner.setSpawnHeightOffset(h);
        }
        for (int i = 0; i < this.spawnPositions.size(); i += 3) {
            int x = posX + this.spawnPositions.get(i) - (posX - this.posX);
            int y = posY + this.spawnPositions.get(i + 1) - (posY - this.posY);
            int z = posZ + this.spawnPositions.get(i + 2) - (posZ - this.posZ);
            world.func_180501_a((BlockPos)p.func_181079_c(x, y, z), TGBlocks.MONSTER_SPAWNER.func_176223_P().func_177226_a((IProperty)TGBlocks.MONSTER_SPAWNER.TYPE, (Comparable)((Object)EnumMonsterSpawnerType.SOLDIER_SPAWN)), 3);
            tile = world.func_175625_s((BlockPos)p);
            if (tile == null || !(tile instanceof TGSpawnerTileEnt)) continue;
            TGSpawnerTileEnt spawner = (TGSpawnerTileEnt)tile;
            spawner.addMobType(ArmySoldier.class, 1);
            spawner.setParams(3, 1, 200, 0);
        }
    }

    public void setRoadBlocks(World world, int x, int y, int z, int roadWidth, int roadLength, boolean alignment) {
        int spawnZ;
        int spawnX;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockUtils.flattenArea(world, x, z, alignment ? roadLength : roadWidth, !alignment ? roadLength : roadWidth, 1);
        for (int a = 0; a < roadLength; ++a) {
            for (int b = 0; b < roadWidth; ++b) {
                MBlock block = roadWidth >= 4 && b > 0 && b < roadWidth - 1 ? MBlockRegister.MILBASE_ROADBLOCK_SECONDARY : MBlockRegister.MILBASE_ROADBLOCK;
                if (alignment) {
                    if (this.maxHeightDiff != 0) {
                        y = this.getGroundY(world, x + a, z + b);
                    }
                    world.func_180501_a((BlockPos)p.func_181079_c(x + a, y, z + b), block.getState(), 2);
                    continue;
                }
                if (this.maxHeightDiff != 0) {
                    y = this.getGroundY(world, x + b, z + a);
                }
                world.func_180501_a((BlockPos)p.func_181079_c(x + b, y, z + a), block.getState(), 2);
            }
        }
        if (alignment) {
            spawnX = x + roadLength / 2;
            spawnZ = z + roadWidth / 2;
        } else {
            spawnZ = z + roadLength / 2;
            spawnX = x + roadWidth / 2;
        }
        int spawnY = this.getGroundY(world, spawnX, spawnZ) + 1;
        this.spawnPositions.add(spawnX - this.posX);
        this.spawnPositions.add(spawnY - this.posY);
        this.spawnPositions.add(spawnZ - this.posZ);
    }

    public void setFenceGateBlocks(World world, int x, int y, int z, int roadWidth, int length, int height, boolean alignment) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int a = 0; a < length; ++a) {
            for (int b = 0; b < roadWidth; ++b) {
                for (int c = 0; c < height + 10; ++c) {
                    if (alignment) {
                        if (this.maxHeightDiff != 0) {
                            y = this.getGroundY(world, x + a, z + b);
                        }
                        if (world.func_180495_p((BlockPos)p.func_181079_c(x + a, y + c + 1, z + b)) != MBlockRegister.MILBASE_FENCE.getState()) continue;
                        world.func_175698_g((BlockPos)p.func_181079_c(x + a, y + c + 1, z + b));
                        continue;
                    }
                    if (this.maxHeightDiff != 0) {
                        y = this.getGroundY(world, x + b, z + a);
                    }
                    if (world.func_180495_p((BlockPos)p.func_181079_c(x + b, y + c + 1, z + a)) != MBlockRegister.MILBASE_FENCE.getState()) continue;
                    world.func_175698_g((BlockPos)p.func_181079_c(x + b, y + c + 1, z + a));
                }
            }
        }
    }

    private int getGroundY(World world, int x, int z) {
        return world.func_189649_b(x, z) - 1;
    }

    public int[] spawnPosAsArray(List<Integer> list) {
        int[] s = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            s[i] = list.get(i);
        }
        return s;
    }

    static {
        militaryCampSpawns = new String[]{"ArmySoldier"};
        minBorderStructureSize = 30;
        maxBorderStructureSize = 80;
        minCornerStructureSize = 20;
        maxCornerStructureSize = 60;
        structures = new ArrayList();
        structures.add(new Tent(5, 4, 5, 7, 5, 7, 0));
        structures.add(new Tent(3, 4, 3, 6, 5, 6, 1));
        structures.add(new Tent(4, 4, 4, 8, 6, 8, 2));
        structures.add(new Containers(2, 3, 2, 7, 3, 7, 2, 2, 2, new MBlock(TGBlocks.METAL_PANEL.func_176223_P())));
        structures.add(new CampProps(1, 3, 1, 5, 5, 5, 0));
        structures.add(new CampProps(3, 5, 3, 6, 7, 6, 1));
        structures.add(new Bunker(5, 3, 5, 8, 3, 8, 0));
        structures.add(new Barracks(7, 7, 7, -1, -1, -1));
        structures.add(new Helipad(7, 7, 7, 10, -1, 10));
        structures.add(new Tanks(4, 5, 4, 10, -1, 10));
        structures.add(new CampProps(3, 5, 3, 10, 7, 10, 5));
        structures.add(new Bunker(3, 3, 5, 15, 3, 15, 2).setSwapXZ(true));
        structures.add(new Bunker(4, 3, 6, 15, 3, 15, 3).setSwapXZ(true));
        borderStructures = new ArrayList();
        borderStructures.add(new Bunker(5, 3, 5, 8, 3, 8, 0));
        borderStructures.add(new Bunker(5, 4, 5, -1, 4, -1, 1));
        borderStructures.add(new CampProps(3, 2, 3, 8, 2, 8, 2));
        borderStructures.add(new CampProps(3, 4, 3, 8, 5, 8, 3));
        borderStructures.add(new CampProps(1, 2, 3, -1, 4, -1, 4).setSwapXZ(true));
        borderStructures.add(new Bunker(3, 3, 5, 10, 3, 10, 2).setSwapXZ(true));
        borderStructures.add(new Bunker(4, 3, 6, 10, 3, 10, 3).setSwapXZ(true));
        cornerStructures = new ArrayList();
        cornerStructures.add(new WatchTowerSmall(3, 8, 3, 4, 8, -1, 3).setSwapXZ(true));
        cornerStructures.add(new WatchTowerSmall(4, 10, 4, -1, 12, -1, 4));
    }

    class CampSegment {
        int x;
        int y;
        int z;
        int sizeX;
        int sizeZ;
        int roadWidth;
        boolean isCenter;
        CampSegment[] subSegments;
        boolean subAlignment = false;
        int direction = 0;
        int splitStep;

        public CampSegment(int x, int y, int z, int sizeX, int sizeZ, int roadWidth, int direction) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sizeX = sizeX;
            this.sizeZ = sizeZ;
            this.roadWidth = Math.max(roadMinWidth, roadWidth);
            this.direction = direction;
        }

        public void setBlocks(World world, Random rnd) {
            if (this.subSegments != null && this.subSegments.length >= 2) {
                for (int i = 0; i < this.subSegments.length; ++i) {
                    this.subSegments[i].setBlocks(world, rnd);
                    if (i >= this.subSegments.length - 1) continue;
                    if (this == MilitaryCamp.this.rootSegment) {
                        int extralength = outerFenceWidth + outerFenceSpacing + 1;
                        if (this.subAlignment) {
                            MilitaryCamp.this.setRoadBlocks(world, this.x - extralength, this.y, this.subSegments[i].z + this.subSegments[i].sizeZ, this.roadWidth, this.sizeX + 2 * extralength, this.subAlignment);
                            MilitaryCamp.this.setFenceGateBlocks(world, this.x - (outerFenceSpacing + outerFenceWidth), this.y, this.subSegments[i].z + this.subSegments[i].sizeZ, this.roadWidth, outerFenceWidth, outerFenceHeight, this.subAlignment);
                            MilitaryCamp.this.setFenceGateBlocks(world, this.x + this.sizeX + outerFenceSpacing, this.y, this.subSegments[i].z + this.subSegments[i].sizeZ, this.roadWidth, outerFenceWidth, outerFenceHeight, this.subAlignment);
                            continue;
                        }
                        MilitaryCamp.this.setRoadBlocks(world, this.subSegments[i].x + this.subSegments[i].sizeX, this.y, this.z - extralength, this.roadWidth, this.sizeZ + 2 * extralength, this.subAlignment);
                        MilitaryCamp.this.setFenceGateBlocks(world, this.subSegments[i].x + this.subSegments[i].sizeX, this.y, this.z - (outerFenceSpacing + outerFenceWidth), this.roadWidth, outerFenceWidth, outerFenceHeight, this.subAlignment);
                        MilitaryCamp.this.setFenceGateBlocks(world, this.subSegments[i].x + this.subSegments[i].sizeX, this.y, this.z + this.sizeZ + outerFenceSpacing, this.roadWidth, outerFenceWidth, outerFenceHeight, this.subAlignment);
                        continue;
                    }
                    if (this.subAlignment) {
                        MilitaryCamp.this.setRoadBlocks(world, this.x - 1, this.y, this.subSegments[i].z + this.subSegments[i].sizeZ, this.roadWidth, this.sizeX + 2, this.subAlignment);
                        continue;
                    }
                    MilitaryCamp.this.setRoadBlocks(world, this.subSegments[i].x + this.subSegments[i].sizeX, this.y, this.z - 1, this.roadWidth, this.sizeZ + 2, this.subAlignment);
                }
            } else if (this.isCenter && MilitaryCamp.this.flagSegment == null) {
                MilitaryCamp.this.flagSegment = this;
            } else {
                WorldgenStructure structure = this.shouldPlaceCornerStructure() ? this.getMatchingStructure(cornerStructures) : (this.shouldPlaceBorderStructure() ? this.getMatchingStructure(borderStructures) : this.getMatchingStructure(structures));
                int height = structure.maxY == -1 || structure.maxY < structure.minY ? structure.minY : structure.minY + MilitaryCamp.this.rand.nextInt(structure.maxY + 1 - structure.minY);
                BlockUtils.flattenArea(world, this.x, this.z, this.sizeX, this.sizeZ, 0);
                this.y = MilitaryCamp.this.getGroundY(world, this.x + this.sizeX / 2, this.z + this.sizeZ / 2);
                structure.setBlocks(world, this.x, this.y, this.z, this.sizeX, height, this.sizeZ, this.direction, MilitaryCamp.this.colorType, rnd);
            }
        }

        private WorldgenStructure getMatchingStructure(ArrayList<WorldgenStructure> list) {
            ArrayList<WorldgenStructure> matchingStructures = new ArrayList<WorldgenStructure>();
            for (WorldgenStructure str : list) {
                if (str.canSwapXZ) {
                    if ((this.sizeX < str.minX || this.sizeZ < str.minZ) && (this.sizeZ < str.minX || this.sizeX < str.minZ) || (str.maxX != -1 && this.sizeX > str.maxX || str.maxZ != -1 && this.sizeZ > str.maxZ) && (str.maxX != -1 && this.sizeZ > str.maxX || str.maxZ != -1 && this.sizeX > str.maxZ)) continue;
                    matchingStructures.add(str);
                    continue;
                }
                if (this.sizeX < str.minX || this.sizeZ < str.minZ || str.maxX != -1 && this.sizeX > str.maxX || str.maxZ != -1 && this.sizeZ > str.maxZ) continue;
                matchingStructures.add(str);
            }
            if (!matchingStructures.isEmpty()) {
                return (WorldgenStructure)matchingStructures.get(MilitaryCamp.this.rand.nextInt(matchingStructures.size()));
            }
            return new EmptyPlane(Blocks.field_150347_e.func_176223_P());
        }

        public boolean generateSubSegments() {
            int size;
            if (this.sizeX >= this.sizeZ) {
                size = this.sizeX;
                this.subAlignment = false;
            } else {
                size = this.sizeZ;
                this.subAlignment = true;
            }
            if (size <= 0) {
                System.out.println("WTF!");
                return false;
            }
            double s = Math.sqrt((double)(size - MilitaryCamp.this.minSubSegmentSize) / (double)(MilitaryCamp.this.maxSubSegmentSize - MilitaryCamp.this.minSubSegmentSize));
            if (size < MilitaryCamp.this.minSubSegmentSize || size < MilitaryCamp.this.maxSubSegmentSize && (double)MilitaryCamp.this.rand.nextFloat() > s * 0.75 + (double)(this.getCenterFactor() * 0.25f)) {
                this.subSegments = null;
                return false;
            }
            int count = 2;
            if (this != MilitaryCamp.this.rootSegment && (double)MilitaryCamp.this.rand.nextFloat() >= 0.5) {
                count = Math.max(2, Math.round(1.0f + MilitaryCamp.this.rand.nextFloat() * 0.5f * (((float)size - (float)(MilitaryCamp.this.minSubSegmentSize + 1) / 2.0f) / (float)(this.roadWidth + 2))));
            }
            double[] parts = new double[count];
            double sum = 0.0;
            for (int i = 0; i < count; ++i) {
                parts[i] = 1.0 + (double)MilitaryCamp.this.rand.nextFloat();
                sum += parts[i];
            }
            int sizeTotal = 0;
            this.subSegments = new CampSegment[count];
            int x1 = this.x;
            int z1 = this.z;
            for (int i = 0; i < count; ++i) {
                int dir;
                int splitSize;
                if (i >= count - 1) {
                    splitSize = size - sizeTotal;
                    dir = this.subAlignment ? 1 : 0;
                } else {
                    splitSize = (int)Math.round(parts[i] / sum * (double)(size - this.roadWidth * count));
                    dir = this.subAlignment ? 3 : 2;
                }
                this.subSegments[i] = !this.subAlignment ? new CampSegment(x1 + sizeTotal, this.y, z1, splitSize, this.sizeZ, this.roadWidth - 1, dir) : new CampSegment(x1, this.y, z1 + sizeTotal, this.sizeX, splitSize, this.roadWidth - 1, dir);
                sizeTotal += splitSize + this.roadWidth;
                if (this.isCenter && this.splitStep <= 1 && i == (count - 1) / 2) {
                    this.subSegments[i].isCenter = true;
                } else if (this.isCenter && i == count - 1) {
                    this.subSegments[i].isCenter = true;
                }
                this.subSegments[i].splitStep = this.splitStep + 1;
                this.subSegments[i].generateSubSegments();
            }
            return true;
        }

        public float getCenterFactor() {
            float f = 0.0f;
            float segmentX = (float)this.x + (float)this.sizeX / 2.0f;
            float segmentZ = (float)this.z + (float)this.sizeZ / 2.0f;
            MathUtil.Vec2 vSeg = new MathUtil.Vec2(segmentX, segmentZ);
            float campX = (float)MilitaryCamp.this.posX + (float)MilitaryCamp.this.sizeX / 2.0f;
            float campZ = (float)MilitaryCamp.this.posZ + (float)MilitaryCamp.this.sizeZ / 2.0f;
            MathUtil.Vec2 vCamp = new MathUtil.Vec2(campX, campZ);
            return 1.0f - (float)(MathUtil.Vec2.substract(vCamp, vSeg).lenSquared() / MilitaryCamp.this.campRadiusSquared);
        }

        public boolean shouldPlaceBorderStructure() {
            int border = outerFenceWidth + outerFenceSpacing;
            boolean isBorderX = this.x <= MilitaryCamp.this.posX + border || this.x + this.sizeX >= MilitaryCamp.this.posX + MilitaryCamp.this.sizeX - border;
            boolean isBorderZ = this.z <= MilitaryCamp.this.posZ + border || this.z + this.sizeZ >= MilitaryCamp.this.posZ + MilitaryCamp.this.sizeZ - border;
            return isBorderX && MilitaryCamp.this.borderChanceX > MilitaryCamp.this.rand.nextFloat() || isBorderZ && MilitaryCamp.this.borderChanceZ > MilitaryCamp.this.rand.nextFloat();
        }

        public boolean shouldPlaceCornerStructure() {
            int border = outerFenceWidth + outerFenceSpacing;
            boolean isCorner = this.x <= MilitaryCamp.this.posX + border && this.z <= MilitaryCamp.this.posZ + border || this.x <= MilitaryCamp.this.posX + border && this.z + this.sizeZ >= MilitaryCamp.this.posZ + MilitaryCamp.this.sizeZ - border || this.x + this.sizeX >= MilitaryCamp.this.posX + MilitaryCamp.this.sizeX - border && this.z <= MilitaryCamp.this.posZ + border || this.x + this.sizeX >= MilitaryCamp.this.posX + MilitaryCamp.this.sizeX - border && this.z + this.sizeZ >= MilitaryCamp.this.posZ + MilitaryCamp.this.sizeZ - border;
            return isCorner && MilitaryCamp.this.cornerChance > MilitaryCamp.this.rand.nextFloat();
        }
    }
}

