/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.structures.WorldgenStructure;

public class NetherDungeonEntrance
extends WorldgenStructure {
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public NetherDungeonEntrance() {
        super(10, 6, 7, 10, 6, 7);
        this.setXYZSize(10, 6, 7);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX - 2, centerZ, direction, 0, this.lootTier, colorType);
    }

    static {
        blockList.add(new MBlock(TGBlocks.NETHER_METAL, 0));
        blockList.add(new MBlock(TGBlocks.NETHER_METAL, 8));
        blockList.add(new MBlock(TGBlocks.NETHER_METAL, 9));
        blockList.add(new MBlock(TGBlocks.NETHER_METAL, 7));
        blockList.add(new MBlock(TGBlocks.DOOR3x3, 4));
        blockList.add(new MBlock(TGBlocks.DOOR3x3, 12));
        blockList.add(new MBlock(Blocks.field_150387_bl, 1));
        blocks = BlockUtils.loadStructureFromFile("netherdungeon_entrance");
    }
}

