/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.blocks.EnumOreClusterType;
import techguns.blocks.EnumOreType;
import techguns.entities.npcs.ZombieMiner;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MBlockBiomeColorType;
import techguns.util.MBlockOreClusterTypeOre;
import techguns.util.MBlockOreclusterType;
import techguns.util.MultiMBlock;
import techguns.util.MultiMMBlock;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.WorldgenStructure;

public class SmallMine
extends WorldgenStructure {
    static short[][] blocks;
    static ArrayList<MBlock> blockList;
    static EnumOreClusterType[] types;
    static MBlock[] ores;
    static int[] oreWeights;
    static int[] clusterWeights;
    static int totalweight;

    public SmallMine() {
        super(17, 11, 11, 17, 11, 11);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        int indexRoll = SmallMine.rollBlockIndex(rnd, totalweight, clusterWeights);
        BlockUtils.cleanUpwards(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 4);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY - 5, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType, indexRoll, rnd);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY - 5, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        blockList = new ArrayList();
        types = new EnumOreClusterType[]{EnumOreClusterType.COAL, EnumOreClusterType.COMMON_METAL, EnumOreClusterType.COMMON_GEM, EnumOreClusterType.RARE_METAL, EnumOreClusterType.SHINY_METAL, EnumOreClusterType.SHINY_GEM, EnumOreClusterType.URANIUM};
        ores = new MBlock[]{new MBlock(Blocks.field_150365_q, 0), new MultiMBlock(new Block[]{Blocks.field_150366_p, TGBlocks.TG_ORE, TGBlocks.TG_ORE}, new int[]{0, EnumOreType.ORE_COPPER.ordinal(), EnumOreType.ORE_TIN.ordinal()}, new int[]{1, 1, 1}), new MultiMBlock(new Block[]{Blocks.field_150450_ax, Blocks.field_150369_x}, new int[]{0, 0}, new int[]{1, 1}), new MBlock(TGBlocks.TG_ORE, EnumOreType.ORE_LEAD.ordinal()), new MultiMBlock(new Block[]{Blocks.field_150352_o, TGBlocks.TG_ORE}, new int[]{0, EnumOreType.ORE_TITANIUM.ordinal()}, new int[]{1, 1}), new MultiMBlock(new Block[]{Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150348_b}, new int[]{0, 0, 0}, new int[]{2, 1, 3}), new MultiMBlock(new Block[]{TGBlocks.TG_ORE, Blocks.field_150348_b}, new int[]{EnumOreType.ORE_URANIUM.ordinal(), 0}, new int[]{1, 1})};
        oreWeights = new int[]{1, 1, 1, 1, 1, 1, 1};
        clusterWeights = new int[]{10, 10, 10, 5, 2, 2, 2};
        totalweight = 0;
        Arrays.stream(clusterWeights).forEach(i -> totalweight += i);
        blockList.add(new MBlock(Blocks.field_150350_a, 0));
        blockList.add(new MBlock(Blocks.field_150348_b, 0));
        blockList.add(new MBlock(Blocks.field_150364_r, 0));
        blockList.add(new MBlockBiomeColorType(new Block[]{Blocks.field_150349_c, Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150424_aL}, new int[]{0, 0, 0, 0}));
        blockList.add(new MBlock(Blocks.field_150364_r, 8));
        blockList.add(new MultiMMBlock(new MBlock[]{new MBlockBiomeColorType(new Block[]{Blocks.field_150349_c, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150424_aL}, new int[]{0, 0, 0, 0}), new MBlock(Blocks.field_150350_a, 0)}, new int[]{4, 1}));
        blockList.add(new MBlock(Blocks.field_150448_aq, 1));
        blockList.add(new MBlock(Blocks.field_150364_r, 4));
        blockList.add(new MBlock(Blocks.field_150446_ar, 1));
        blockList.add(new MBlock(Blocks.field_150448_aq, 3));
        blockList.add(new MBlock(Blocks.field_150478_aa, 3));
        blockList.add(new MBlock(Blocks.field_150478_aa, 4));
        blockList.add(new MBlock(Blocks.field_150478_aa, 2));
        blockList.add(new MBlockOreClusterTypeOre(ores, oreWeights, new MBlock(Blocks.field_150348_b, 0), 0.75f));
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.HOLE, 2, 1, 200, 1).addMobType(ZombieMiner.class, 1));
        blockList.add(new MBlockOreclusterType(types, clusterWeights, 0.5f, ores));
        blockList.add(new MBlockOreclusterType(types, clusterWeights, 0.0f, null));
        blocks = BlockUtils.loadStructureFromFile("small_mine");
    }
}

