/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io.action;

import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.api.io.Folder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FileAction {
    private Type type;
    private NBTTagCompound data;

    private FileAction(Type type, NBTTagCompound data) {
        this.type = type;
        this.data = data;
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", this.type.ordinal());
        tag.func_74782_a("data", (NBTBase)this.data);
        return tag;
    }

    public static FileAction fromTag(NBTTagCompound tag) {
        Type type = Type.values()[tag.func_74762_e("type")];
        NBTTagCompound data = tag.func_74775_l("data");
        return new FileAction(type, data);
    }

    public Type getType() {
        return this.type;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    public static class Factory {
        public static FileAction makeNew(Folder parent, File file, boolean override) {
            NBTTagCompound vars = new NBTTagCompound();
            vars.func_74778_a("directory", parent.getPath());
            vars.func_74778_a("file_name", file.getName());
            vars.func_74757_a("override", override);
            vars.func_74782_a("data", (NBTBase)file.toTag());
            return new FileAction(Type.NEW, vars);
        }

        public static FileAction makeDelete(File file) {
            NBTTagCompound vars = new NBTTagCompound();
            vars.func_74778_a("directory", file.getLocation());
            vars.func_74778_a("file_name", file.getName());
            return new FileAction(Type.DELETE, vars);
        }

        public static FileAction makeRename(File file, String newFileName) {
            NBTTagCompound vars = new NBTTagCompound();
            vars.func_74778_a("directory", file.getLocation());
            vars.func_74778_a("file_name", file.getName());
            vars.func_74778_a("new_file_name", newFileName);
            return new FileAction(Type.RENAME, vars);
        }

        public static FileAction makeData(File file, NBTTagCompound data) {
            NBTTagCompound vars = new NBTTagCompound();
            vars.func_74778_a("directory", file.getLocation());
            vars.func_74778_a("file_name", file.getName());
            vars.func_74782_a("data", (NBTBase)data);
            return new FileAction(Type.DATA, vars);
        }

        public static FileAction makeCopyCut(File source, Folder destination, boolean override, boolean cut) {
            NBTTagCompound vars = new NBTTagCompound();
            vars.func_74778_a("directory", source.getLocation());
            vars.func_74778_a("file_name", source.getName());
            vars.func_74778_a("destination_drive", destination.getDrive().getUUID().toString());
            vars.func_74778_a("destination_folder", destination.getPath());
            vars.func_74757_a("override", override);
            vars.func_74757_a("cut", cut);
            return new FileAction(Type.COPY_CUT, vars);
        }
    }

    public static enum Type {
        NEW,
        DELETE,
        RENAME,
        DATA,
        COPY_CUT;

    }
}

