/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.drive.AbstractDrive;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskSetupFileBrowser
extends Task {
    private BlockPos pos;
    private boolean includeMain;
    private AbstractDrive mainDrive;
    private Map<UUID, AbstractDrive> availableDrives;

    private TaskSetupFileBrowser() {
        super("get_file_system");
    }

    public TaskSetupFileBrowser(BlockPos pos, boolean includeMain) {
        this();
        this.pos = pos;
        this.includeMain = includeMain;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74772_a("pos", this.pos.func_177986_g());
        nbt.func_74757_a("include_main", this.includeMain);
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")));
        if (tileEntity instanceof TileEntityLaptop) {
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            if (nbt.func_74767_n("include_main")) {
                this.mainDrive = fileSystem.getMainDrive();
            }
            this.availableDrives = fileSystem.getAvailableDrives(world, false);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        if (this.isSucessful()) {
            if (this.mainDrive != null) {
                NBTTagCompound mainDriveTag = new NBTTagCompound();
                mainDriveTag.func_74778_a("name", this.mainDrive.getName());
                mainDriveTag.func_74778_a("uuid", this.mainDrive.getUUID().toString());
                mainDriveTag.func_74778_a("type", this.mainDrive.getType().toString());
                nbt.func_74782_a("main_drive", (NBTBase)mainDriveTag);
                nbt.func_74782_a("structure", (NBTBase)this.mainDrive.getDriveStructure().toTag());
            }
            NBTTagList driveList = new NBTTagList();
            this.availableDrives.forEach((k, v) -> {
                NBTTagCompound driveTag = new NBTTagCompound();
                driveTag.func_74778_a("name", v.getName());
                driveTag.func_74778_a("uuid", v.getUUID().toString());
                driveTag.func_74778_a("type", v.getType().toString());
                driveList.func_74742_a((NBTBase)driveTag);
            });
            nbt.func_74782_a("available_drives", (NBTBase)driveList);
        }
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

