/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.auction.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.programs.auction.AuctionManager;
import com.mrcrayfish.device.programs.auction.object.AuctionItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TaskAddAuction
extends Task {
    private int slot;
    private int amount;
    private int price;
    private int duration;
    private AuctionItem item;

    public TaskAddAuction() {
        super("minebay_add_auction");
    }

    public TaskAddAuction(int slot, int amount, int price, int duration) {
        this();
        this.slot = slot;
        this.amount = amount;
        this.price = price;
        this.duration = duration;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74768_a("slot", this.slot);
        nbt.func_74768_a("amount", this.amount);
        nbt.func_74768_a("price", this.price);
        nbt.func_74768_a("duration", this.duration);
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        ItemStack real;
        int slot = nbt.func_74762_e("slot");
        int amount = nbt.func_74762_e("amount");
        int price = nbt.func_74762_e("price");
        int duration = nbt.func_74762_e("duration");
        if (slot >= 0 && price >= 0 && slot < player.field_71071_by.func_70302_i_() && (real = player.field_71071_by.func_70301_a(slot)) != null) {
            ItemStack stack = real.func_77946_l();
            stack.func_190920_e(amount);
            real.func_190918_g(amount);
            this.item = new AuctionItem(stack, price, duration, player.func_110124_au());
            AuctionManager.INSTANCE.addItem(this.item);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        if (this.isSucessful()) {
            this.item.writeToNBT(nbt);
        }
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
        if (this.isSucessful()) {
            AuctionManager.INSTANCE.addItem(AuctionItem.readFromNBT(nbt));
        }
    }
}

