/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.entity;

import icbm.classic.api.IWorldPosition;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityICBM
extends Entity
implements IWorldPosition {
    protected boolean hasHealth = false;
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntityICBM.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityICBM(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(0.0f));
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue();
    }

    public void setHealth(float health) {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(MathHelper.func_76131_a((float)health, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getMaxHealth() {
        return 5.0f;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.hasHealth && damage > 0.0f && this.canDamage(this, source)) {
            this.setHealth(Math.max(this.getHealth() - damage, 0.0f));
            if (this.getHealth() <= 0.0f) {
                this.onDestroyedBy(source, damage);
            }
            return true;
        }
        return false;
    }

    public boolean canDamage(Entity entity, DamageSource source) {
        if (!entity.func_180431_b(source) && entity.func_70089_S()) {
            return !(entity instanceof EntityLivingBase) || !(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d;
        }
        return false;
    }

    protected void onDestroyedBy(DamageSource source, float damage) {
        this.func_70106_y();
    }

    protected void alignToBounds() {
        this.field_70165_t = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        this.field_70163_u = this.func_174813_aQ().field_72338_b + this.func_70033_W() - (double)this.field_70131_O;
        this.field_70161_v = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
    }

    public Pos getPredictedPosition(int t) {
        Pos newPos = new Pos(this);
        for (int i = 0; i < t; ++i) {
            newPos.add(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        return newPos;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setHealth(nbt.func_74760_g("health"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74776_a("health", this.getHealth());
    }

    @Override
    public World world() {
        return this.field_70170_p;
    }

    @Override
    public double x() {
        return this.field_70165_t;
    }

    @Override
    public double y() {
        return this.field_70163_u;
    }

    @Override
    public double z() {
        return this.field_70161_v;
    }

    public Pos getVelocity() {
        return new Pos(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }
}

