/*
 * Decompiled with CFR 0.152.
 */
package lumien.bloodmoon.config;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Config(modid="bloodmoon", category="bloodmoon")
public class BloodmoonConfig {
    public static General GENERAL = new General();
    @Config.Name(value="appearance")
    public static Appearance APPEARANCE = new Appearance();
    @Config.Name(value="schedule")
    public static Schedule SCHEDULE = new Schedule();
    @Config.Name(value="spawning")
    public static Spawning SPAWNING = new Spawning();
    static HashMap<String, String> classToEntityNameMap = new HashMap();

    public static boolean canSpawn(Class<? extends Entity> entityClass) {
        String entityName;
        if (BloodmoonConfig.SPAWNING.SPAWN_WHITELIST.length == 0) {
            String entityName2;
            if (BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST.length == 0) {
                return true;
            }
            String className = entityClass.getName();
            if (classToEntityNameMap.containsKey(className)) {
                entityName2 = classToEntityNameMap.get(className);
            } else {
                entityName2 = BloodmoonConfig.getEntityName(entityClass);
                classToEntityNameMap.put(className, entityName2);
            }
            for (int i = 0; i < BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST.length; ++i) {
                if (!BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST[i].equals(entityName2)) continue;
                return false;
            }
            return true;
        }
        String className = entityClass.getName();
        if (classToEntityNameMap.containsKey(className)) {
            entityName = classToEntityNameMap.get(className);
        } else {
            entityName = BloodmoonConfig.getEntityName(entityClass);
            classToEntityNameMap.put(className, entityName);
        }
        for (int i = 0; i < BloodmoonConfig.SPAWNING.SPAWN_WHITELIST.length; ++i) {
            if (!BloodmoonConfig.SPAWNING.SPAWN_WHITELIST[i].equals(entityName)) continue;
            return true;
        }
        return false;
    }

    public static String getEntityName(Class<? extends Entity> entityClass) {
        EntityRegistry.EntityRegistration registration;
        String entityName = null;
        entityName = EntityList.func_191302_a((ResourceLocation)EntityList.func_191306_a(entityClass));
        if (entityName == null && (registration = EntityRegistry.instance().lookupModSpawn(entityClass, false)) != null) {
            entityName = registration.getEntityName();
        }
        return entityName;
    }

    public static class Spawning {
        @Config.Name(value="SpawnSpeed")
        @Config.Comment(value={"How much faster enemys spawn on a bloodmoon (0=Vanilla)"})
        public int SPAWN_SPEED = 4;
        @Config.Name(value="SpawnLimitMultiplier")
        @Config.Comment(value={"With which number should the default entity limit be multiplicated on a blood moon"})
        public int SPAWN_LIMIT_MULT = 4;
        @Config.Name(value="SpawnRange")
        @Config.Comment(value={"How close can enemys spawn next to the player on a bloodmoon in blocks? (Vanilla=24)"})
        public int SPAWN_RANGE = 2;
        @Config.Name(value="WorldSpawnDistance")
        @Config.Comment(value={"How close can enemys spawn next to the World Spawn (Vanilla=24)"})
        public int SPAWN_DISTANCE = 24;
        @Config.Name(value="SpawnWhitelist")
        @Config.Comment(value={"If this isn't empty only monsters which names are in this list will get spawned by the bloodmoon. (Example: \"Skeleton,Spider\")"})
        public String[] SPAWN_WHITELIST = new String[0];
        @Config.Name(value="SpawnBlacklist")
        @Config.Comment(value={"Monsters which names are on this list won't get spawned by the bloodmoon (Has no effect when a whitelist is active). (Example: \"Skeleton,Spider\")"})
        public String[] SPAWN_BLACKLIST = new String[0];
    }

    public static class Schedule {
        @Config.Name(value="Chance")
        @Config.Comment(value={"The chance of a bloodmoon occuring at the beginning of a night (0=Never;1=Every night;0.05=5% of all nights)"})
        public double CHANCE = 0.05;
        @Config.Name(value="Fullmoon")
        @Config.Comment(value={"Whether there should be a bloodmoon whenever there is a full moon"})
        public boolean FULLMOON = false;
        @Config.Name(value="NthNight")
        @Config.Comment(value={"Every nth night there will be a bloodmoon (0 disables this, 1 would be every night, 2 every second night)"})
        public int NTH_NIGHT = 0;
    }

    public static class Appearance {
        @Config.Name(value="RedMoon")
        public boolean RED_MOON = true;
        @Config.Name(value="RedSky")
        public boolean RED_SKY = true;
        @Config.Name(value="RedLight")
        public boolean RED_LIGHT = true;
        @Config.Name(value="BlackFog")
        public boolean BLACK_FOG = true;
    }

    public static class General {
        @Config.Name(value="NoSleep")
        @Config.Comment(value={"Whether players are not able to sleep on a bloodmoon"})
        public boolean NO_SLEEP = true;
        @Config.Name(value="Vanish")
        @Config.Comment(value={"Whether monsters spawned by a bloodmoon should die at dawn"})
        public boolean VANISH = false;
        @Config.Name(value="RespectGamerule")
        @Config.Comment(value={"Whether bloodmoons should respect the doMobSpawning gamerule"})
        public boolean RESPECT_GAMERULE = true;
        @Config.Name(value="SendMessage")
        @Config.Comment(value={"Whether all players in the overworld should receive a message when the bloodmoon starts"})
        public boolean SEND_MESSAGE = true;
    }
}

