/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.apparatus.FlightApparatuses;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.util.CubicBezier;
import me.paulf.wings.util.Mth;
import me.paulf.wings.util.NBTSerializer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class FlightDefault
implements Flight {
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private final List<Flight.FlyingListener> flyingListeners = Lists.newArrayList();
    private final List<Flight.SyncListener> syncListeners = Lists.newArrayList();
    private final WingState voidState = new WingState(Items.field_190931_a, FlightApparatus.FlightState.VOID);
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private WingState state = this.voidState;

    @Override
    public void setIsFlying(boolean isFlying, Flight.PlayerSet players) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            this.flyingListeners.forEach(Flight.FlyingListener.onChangeUsing(isFlying));
            this.sync(players);
        }
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public void setTimeFlying(int timeFlying) {
        this.timeFlying = timeFlying;
    }

    @Override
    public int getTimeFlying() {
        return this.timeFlying;
    }

    @Override
    public float getFlyingAmount(float delta) {
        return FLY_AMOUNT_CURVE.eval(Mth.lerp(this.getPrevTimeFlying(), this.getTimeFlying(), delta) / 20.0f);
    }

    private void setPrevTimeFlying(int prevTimeFlying) {
        this.prevTimeFlying = prevTimeFlying;
    }

    private int getPrevTimeFlying() {
        return this.prevTimeFlying;
    }

    @Override
    public void registerFlyingListener(Flight.FlyingListener listener) {
        this.flyingListeners.add(listener);
    }

    @Override
    public void registerSyncListener(Flight.SyncListener listener) {
        this.syncListeners.add(listener);
    }

    @Override
    public boolean canFly(EntityPlayer player) {
        ItemStack stack = FlightApparatuses.find((EntityLivingBase)player);
        FlightApparatus apparatus = FlightApparatuses.get(stack);
        return apparatus != null && apparatus.isUsable(player, stack);
    }

    @Override
    public boolean canLand(EntityPlayer player, ItemStack wings) {
        FlightApparatus apparatus = FlightApparatuses.get(wings);
        return apparatus != null && apparatus.isLandable(player, wings);
    }

    private void onWornUpdate(EntityPlayer player, ItemStack wings) {
        if (player.func_70613_aW()) {
            if (this.isFlying()) {
                float speed = (float)MathHelper.func_151238_b((double)0.03f, (double)0.0715f, (double)player.field_191988_bg);
                float elevationBoost = Mth.transform(Math.abs(player.field_70125_A), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -Mth.toRadians(player.field_70125_A - 30.0f * elevationBoost);
                float yaw = -Mth.toRadians(player.field_70177_z) - (float)Math.PI;
                float vxz = -MathHelper.func_76134_b((float)pitch);
                float vy = MathHelper.func_76126_a((float)pitch);
                float vz = MathHelper.func_76134_b((float)yaw);
                float vx = MathHelper.func_76126_a((float)yaw);
                player.field_70159_w += (double)(vx * vxz * speed);
                player.field_70181_x = player.field_70181_x + ((double)(vy * speed) + (double)0.05f * (player.field_70125_A > 0.0f ? (double)elevationBoost : 1.0));
                player.field_70179_y += (double)(vz * vxz * speed);
            }
            if (this.canLand(player, wings)) {
                if (player.field_70181_x < 0.0) {
                    player.field_70181_x *= (double)0.9f;
                }
                player.field_70143_R = 0.0f;
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            FlightApparatus apparatus = FlightApparatuses.get(wings);
            if (apparatus == null) {
                this.state = this.state.next();
            } else if (apparatus.isUsable(player, wings)) {
                this.state = this.state.next(wings, apparatus);
                this.state.onUpdate(player, wings);
            } else if (this.isFlying()) {
                this.setIsFlying(false, Flight.PlayerSet.ofAll());
                this.state = this.state.next();
            }
        }
    }

    @Override
    public void tick(EntityPlayer player, ItemStack wings) {
        if (!wings.func_190926_b()) {
            this.onWornUpdate(player, wings);
        } else if (!player.field_70170_p.field_72995_K && this.isFlying()) {
            this.setIsFlying(false, Flight.PlayerSet.ofAll());
        }
        this.setPrevTimeFlying(this.getTimeFlying());
        if (this.isFlying()) {
            if (this.getTimeFlying() < 20) {
                this.setTimeFlying(this.getTimeFlying() + 1);
            } else if (player.func_175144_cb() && player.field_70122_E) {
                this.setIsFlying(false, Flight.PlayerSet.ofOthers());
            }
        } else if (this.getTimeFlying() > 0) {
            this.setTimeFlying(this.getTimeFlying() - 1);
        }
    }

    @Override
    public void onFlown(EntityPlayer player, ItemStack wings, Vec3d direction) {
        FlightApparatus apparatus;
        if (!wings.func_190926_b() && (apparatus = FlightApparatuses.get(wings)) != null) {
            if (this.isFlying()) {
                apparatus.onFlight(player, wings, direction);
            } else if (player.field_70181_x < -0.5) {
                apparatus.onLanding(player, wings, direction);
            }
        }
    }

    @Override
    public void clone(Flight other) {
        this.setIsFlying(other.isFlying());
        this.setTimeFlying(other.getTimeFlying());
    }

    @Override
    public void sync(Flight.PlayerSet players) {
        this.syncListeners.forEach(Flight.SyncListener.onSyncUsing(players));
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeBoolean(this.isFlying());
        buf.func_150787_b(this.getTimeFlying());
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.setIsFlying(buf.readBoolean());
        this.setTimeFlying(buf.func_150792_a());
    }

    private final class WingState {
        private final Item item;
        private final FlightApparatus.FlightState activity;

        private WingState(Item item, FlightApparatus.FlightState activity) {
            this.item = item;
            this.activity = activity;
        }

        private WingState next() {
            return FlightDefault.this.voidState;
        }

        private WingState next(ItemStack stack, FlightApparatus wf) {
            Item item = stack.func_77973_b();
            if (this.item.equals(item)) {
                return this;
            }
            return new WingState(item, wf.createState(FlightDefault.this));
        }

        private void onUpdate(EntityPlayer player, ItemStack stack) {
            this.activity.onUpdate(player, stack);
        }
    }

    public static final class Serializer
    implements NBTSerializer<FlightDefault, NBTTagCompound> {
        private static final String IS_FLYING = "isFlying";
        private static final String TIME_FLYING = "timeFlying";
        private final Supplier<FlightDefault> factory;

        public Serializer(Supplier<FlightDefault> factory) {
            this.factory = factory;
        }

        @Override
        public NBTTagCompound serialize(FlightDefault instance) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a(IS_FLYING, instance.isFlying());
            compound.func_74768_a(TIME_FLYING, instance.getTimeFlying());
            return compound;
        }

        @Override
        public FlightDefault deserialize(NBTTagCompound compound) {
            FlightDefault f = this.factory.get();
            f.setIsFlying(compound.func_74767_n(IS_FLYING));
            f.setTimeFlying(compound.func_74762_e(TIME_FLYING));
            return f;
        }
    }
}

