/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class CustomizableSCTE
extends TileEntitySCTE
implements IModuleInventory,
ICustomizable {
    private boolean linkable = false;
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private NBTTagList nbtTagStorage = null;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        if (tag.func_74764_b("linkable")) {
            this.linkable = tag.func_74767_n("linkable");
        }
        if (this.linkable && tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        tag.func_74757_a("linkable", this.linkable);
        if (this.linkable && this.func_145830_o() && this.linkedBlocks.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            WorldUtils.addScheduledTask(this.field_145850_b, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    NBTTagCompound toAppend = new NBTTagCompound();
                    if (block != null) {
                        if (!block.validate(this.field_145850_b)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.func_74778_a("blockName", block.blockName);
                        toAppend.func_74768_a("blockX", block.getX());
                        toAppend.func_74768_a("blockY", block.getY());
                        toAppend.func_74768_a("blockZ", block.getZ());
                    }
                    tagList.func_74742_a((NBTBase)toAppend);
                }
                tag.func_74782_a("linkedBlocks", (NBTBase)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(NBTTagList list) {
        if (!this.linkable) {
            return;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, x, y, z);
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.func_74744_a(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            CustomizableSCTE.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.hasCustomName() ? this.getCustomName() : "Customize", new Object[0]);
    }

    @Override
    public boolean hasCustomName() {
        return this.getCustomName() != null && !this.getCustomName().equals("name");
    }

    @Override
    public void onTileEntityDestroyed() {
        if (this.linkable) {
            for (LinkedBlock block : this.linkedBlocks) {
                CustomizableSCTE.unlink(block.asTileEntity(this.field_145850_b), this);
            }
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    public CustomizableSCTE linkable() {
        this.linkable = true;
        return this;
    }

    public boolean canBeLinkedWith() {
        return this.linkable;
    }

    public static void link(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        if (CustomizableSCTE.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return false;
        }
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, CustomizableSCTE excludedTE) {
        ArrayList<CustomizableSCTE> list = new ArrayList<CustomizableSCTE>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
        if (!this.linkable) {
            return;
        }
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.field_145850_b))) continue;
            block.asTileEntity(this.field_145850_b).onLinkedBlockAction(action, parameters, excludedTEs);
            block.asTileEntity(this.field_145850_b).sync();
        }
    }

    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
    }
}

