/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.DataSerializerEntry;

public class Owner {
    @GameRegistry.ObjectHolder(value="securitycraft:owner")
    public static final DataSerializerEntry SERIALIZER = null;
    private String playerName = "owner";
    private String playerUUID = "ownerUUID";

    public Owner() {
    }

    public Owner(String playerName, String playerUUID) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null) continue;
            String uuid = ownable.getOwner().getUUID();
            String owner = ownable.getOwner().getName();
            if (uuid != null && !uuid.equals(this.playerUUID)) {
                return false;
            }
            if (owner == null || !uuid.equals("ownerUUID") || owner.equals("owner") || owner.equals(this.playerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        String uuid = player.func_146103_bH().getId().toString();
        String owner = player.func_70005_c_();
        if (uuid != null && uuid.equals(this.playerUUID)) {
            return true;
        }
        return owner != null && this.playerUUID.equals("ownerUUID") && owner.equals(this.playerName);
    }

    public void set(String uuid, String name) {
        this.playerName = name;
        this.playerUUID = uuid;
    }

    public void set(Owner newOwner) {
        this.playerName = newOwner.getName();
        this.playerUUID = newOwner.getUUID();
    }

    public void setOwnerName(String name) {
        this.playerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.playerUUID = uuid;
    }

    public String getName() {
        return this.playerName;
    }

    public String getUUID() {
        return this.playerUUID;
    }

    public String toString() {
        return "Name: " + this.playerName + "  UUID: " + this.playerUUID;
    }

    public boolean equals(Object obj) {
        return obj instanceof Owner && this.getName().equals(((Owner)obj).getName()) && this.getUUID().equals(((Owner)obj).getUUID());
    }

    public static DataSerializer<Owner> getSerializer() {
        return SERIALIZER.getSerializer();
    }
}

