/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WailaDataProvider
implements IWailaDataProvider,
IWailaEntityProvider {
    private static final String SHOW_OWNER = "securitycraft.showowner";
    private static final String SHOW_MODULES = "securitycraft.showmodules";
    private static final String SHOW_PASSWORDS = "securitycraft.showpasswords";
    private static final String SHOW_CUSTOM_NAME = "securitycraft.showcustomname";

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.addConfig("SecurityCraft", SHOW_OWNER, ClientUtils.localize("waila.securitycraft:displayOwner", new Object[0]));
        registrar.addConfig("SecurityCraft", SHOW_MODULES, ClientUtils.localize("waila.securitycraft:showModules", new Object[0]));
        registrar.addConfig("SecurityCraft", SHOW_PASSWORDS, ClientUtils.localize("waila.securitycraft:showPasswords", new Object[0]));
        registrar.addConfig("SecurityCraft", SHOW_CUSTOM_NAME, ClientUtils.localize("waila.securitycraft:showCustomName", new Object[0]));
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(), IOwnable.class);
        registrar.registerStackProvider((IWailaDataProvider)new WailaDataProvider(), IOverlayDisplay.class);
        registrar.registerBodyProvider((IWailaEntityProvider)new WailaDataProvider(), EntitySentry.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof IOverlayDisplay) {
            return ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> body, IWailaDataAccessor data, IWailaConfigHandler config) {
        IBlockState disguisedBlockState;
        World world = data.getWorld();
        BlockPos pos = data.getPosition();
        IBlockState state = data.getBlockState();
        Block block = data.getBlock();
        boolean disguised = false;
        if (block instanceof BlockDisguisable && (disguisedBlockState = ((BlockDisguisable)block).getDisguisedBlockState((IBlockAccess)world, pos)) != null) {
            disguised = true;
            block = disguisedBlockState.func_177230_c();
        }
        if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(world, state, pos)) {
            return body;
        }
        TileEntity te = data.getTileEntity();
        if (config.getConfig(SHOW_OWNER) && te instanceof IOwnable && block.getRegistryName().func_110624_b().equals("securitycraft")) {
            body.add(ClientUtils.localize("waila.securitycraft:owner", new Object[0]) + " " + ((IOwnable)te).getOwner().getName());
        }
        if (!disguised) {
            if (config.getConfig(SHOW_MODULES) && te instanceof IModuleInventory && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner(data.getPlayer()))) {
                if (!((IModuleInventory)te).getInsertedModules().isEmpty()) {
                    body.add(ClientUtils.localize("waila.securitycraft:equipped", new Object[0]));
                }
                for (EnumModuleType module : ((IModuleInventory)te).getInsertedModules()) {
                    body.add("- " + ClientUtils.localize(module.getTranslationKey(), new Object[0]));
                }
            }
            if (config.getConfig(SHOW_PASSWORDS) && te instanceof IPasswordProtected && !(te instanceof TileEntityKeycardReader) && ((IOwnable)te).getOwner().isOwner(data.getPlayer())) {
                String password = ((IPasswordProtected)te).getPassword();
                body.add(ClientUtils.localize("waila.securitycraft:password", new Object[0]) + " " + (password != null && !password.isEmpty() ? password : ClientUtils.localize("waila.securitycraft:password.notSet", new Object[0])));
            }
            if (config.getConfig(SHOW_CUSTOM_NAME) && te instanceof INameable && ((INameable)te).canBeNamed()) {
                String name = ((INameable)te).getCustomName();
                body.add(ClientUtils.localize("waila.securitycraft:customName", new Object[0]) + " " + (((INameable)te).hasCustomName() ? name : ClientUtils.localize("waila.securitycraft:customName.notSet", new Object[0])));
            }
        }
        return body;
    }

    public List<String> getWailaBody(Entity entity, List<String> body, IWailaEntityAccessor data, IWailaConfigHandler config) {
        EntitySentry sentry;
        if (config.getConfig(SHOW_OWNER) && data.getEntity() instanceof EntitySentry) {
            body.add(ClientUtils.localize("waila.securitycraft:owner", new Object[0]) + " " + ((EntitySentry)entity).getOwner().getName());
        }
        if (config.getConfig(SHOW_MODULES) && entity instanceof EntitySentry && ((EntitySentry)entity).getOwner().isOwner(data.getPlayer()) && (!(sentry = (EntitySentry)entity).getWhitelistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b())) {
            body.add(ClientUtils.localize("waila.securitycraft:equipped", new Object[0]));
            if (!sentry.getWhitelistModule().func_190926_b()) {
                body.add("- " + ClientUtils.localize(EnumModuleType.WHITELIST.getTranslationKey(), new Object[0]));
            }
            if (!sentry.getDisguiseModule().func_190926_b()) {
                body.add("- " + ClientUtils.localize(EnumModuleType.DISGUISE.getTranslationKey(), new Object[0]));
            }
        }
        if (entity instanceof EntitySentry) {
            sentry = (EntitySentry)entity;
            EntitySentry.EnumSentryMode mode = sentry.getMode();
            if (mode == EntitySentry.EnumSentryMode.AGGRESSIVE) {
                body.add(ClientUtils.localize("messages.securitycraft:sentry.mode1", new Object[0]));
            } else if (mode == EntitySentry.EnumSentryMode.CAMOUFLAGE) {
                body.add(ClientUtils.localize("messages.securitycraft:sentry.mode2", new Object[0]));
            } else {
                body.add(ClientUtils.localize("messages.securitycraft:sentry.mode3", new Object[0]));
            }
        }
        return body;
    }
}

