/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerProjector;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.network.packets.PacketSSyncProjector;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiProjector
extends GuiContainer
implements GuiSlider.ISlider {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private TileEntityProjector te;
    private String blockName;
    private HoverChecker[] hoverCheckers = new HoverChecker[3];
    private GuiSlider projectionWidth;
    private GuiSlider projectionRange;
    private GuiSlider projectionOffset;
    private int sliderWidth = 120;

    public GuiProjector(InventoryPlayer inv, TileEntityProjector te) {
        super((Container)new ContainerProjector(inv, te));
        this.te = te;
        this.blockName = ClientUtils.localize(te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c().func_149739_a() + ".name", new Object[0]);
        this.field_147000_g = 225;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.projectionWidth = new GuiSlider(ClientUtils.localize("gui.securitycraft:projector.width", new Object[0]).replace("#", this.te.getProjectionWidth() + ""), this.blockName, 0, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 50, this.sliderWidth, 20, ClientUtils.localize("gui.securitycraft:projector.width", new Object[0]).replace("#", ""), 1, 10, this.te.getProjectionWidth(), false, true, (GuiSlider.ISlider)this);
        this.projectionWidth.packedFGColour = 0xE0E0E0;
        this.projectionRange = new GuiSlider(ClientUtils.localize("gui.securitycraft:projector.range", new Object[0]).replace("#", this.te.getProjectionRange() + ""), this.blockName, 1, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 80, this.sliderWidth, 20, ClientUtils.localize("gui.securitycraft:projector.range", new Object[0]).replace("#", ""), 1, 30, this.te.getProjectionRange(), false, true, (GuiSlider.ISlider)this);
        this.projectionWidth.packedFGColour = 0xE0E0E0;
        this.projectionOffset = new GuiSlider(ClientUtils.localize("gui.securitycraft:projector.offset", new Object[0]).replace("#", this.te.getProjectionOffset() + ""), this.blockName, 2, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 110, this.sliderWidth, 20, ClientUtils.localize("gui.securitycraft:projector.offset", new Object[0]).replace("#", ""), -10, 10, this.te.getProjectionOffset(), false, true, (GuiSlider.ISlider)this);
        this.projectionWidth.packedFGColour = 0xE0E0E0;
        this.func_189646_b((GuiButton)this.projectionWidth);
        this.func_189646_b((GuiButton)this.projectionRange);
        this.func_189646_b((GuiButton)this.projectionOffset);
        this.hoverCheckers[0] = new HoverChecker((GuiButton)this.projectionWidth, 20);
        this.hoverCheckers[1] = new HoverChecker((GuiButton)this.projectionRange, 20);
        this.hoverCheckers[2] = new HoverChecker((GuiButton)this.projectionOffset, 20);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.hoverCheckers[0] != null && this.hoverCheckers[0].checkHover(mouseX, mouseY)) {
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(ClientUtils.localize("gui.securitycraft:projector.width.description", new Object[0]), 150), mouseX, mouseY, this.field_146289_q);
        }
        if (this.hoverCheckers[1] != null && this.hoverCheckers[1].checkHover(mouseX, mouseY)) {
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(ClientUtils.localize("gui.securitycraft:projector.range.description", new Object[0]), 150), mouseX, mouseY, this.field_146289_q);
        }
        if (this.hoverCheckers[2] != null && this.hoverCheckers[2].checkHover(mouseX, mouseY)) {
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(ClientUtils.localize("gui.securitycraft:projector.offset.description", new Object[0]), 150), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.blockName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.blockName) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void onMouseRelease(int id) {
        if (id == this.projectionWidth.field_146127_k) {
            this.te.setProjectionWidth(this.projectionWidth.getValueInt());
        } else if (id == this.projectionRange.field_146127_k) {
            this.te.setProjectionRange(this.projectionRange.getValueInt());
        } else if (id == this.projectionOffset.field_146127_k) {
            this.te.setProjectionOffset(this.projectionOffset.getValueInt());
        }
        SecurityCraft.network.sendToServer((IMessage)new PacketSSyncProjector(this.te.func_174877_v().func_177958_n(), this.te.func_174877_v().func_177956_o(), this.te.func_174877_v().func_177952_p(), this.projectionWidth.getValueInt(), this.projectionRange.getValueInt(), this.projectionOffset.getValueInt()));
    }

    @Override
    public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
        slider.field_146126_j = slider.prefix + slider.getValueInt();
    }
}

