/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.ItemModule;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum EnumModuleType {
    REDSTONE(SCContent.redstoneModule, "redstone_module"),
    WHITELIST(SCContent.whitelistModule, "whitelist_module"),
    BLACKLIST(SCContent.blacklistModule, "blacklist_module"),
    HARMING(SCContent.harmingModule, "harming_module"),
    SMART(SCContent.smartModule, "smart_module"),
    STORAGE(SCContent.storageModule, "storage_module"),
    DISGUISE(SCContent.disguiseModule, "disguise_module");

    private ItemModule module;
    private String registryPath;

    private EnumModuleType(ItemModule moduleItem, String registryPath) {
        this.module = moduleItem;
        this.registryPath = registryPath;
    }

    public ItemModule getItem() {
        return this.module;
    }

    public String getTranslationKey() {
        return this.module.func_77658_a() + ".name";
    }

    public String getRegistryPath() {
        return this.registryPath;
    }

    public static EnumModuleType getModuleFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemModule) {
            return ((ItemModule)stack.func_77973_b()).getModuleType();
        }
        return null;
    }

    public static void refresh() {
        for (EnumModuleType module : EnumModuleType.values()) {
            module.module = (ItemModule)ForgeRegistries.ITEMS.getValue(new ResourceLocation("securitycraft", module.getRegistryPath()));
        }
    }
}

