/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class TileEntityLaserBlock
extends TileEntityDisguisable {
    private Option.OptionBoolean enabledOption = new Option.OptionBoolean("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            TileEntityLaserBlock.this.toggleLaser(this);
        }
    };

    private void toggleLaser(Option.OptionBoolean option) {
        if (BlockUtils.getBlock((IBlockAccess)this.field_145850_b, this.field_174879_c) != SCContent.laserBlock) {
            return;
        }
        if (((Boolean)option.get()).booleanValue()) {
            ((BlockLaserBlock)BlockUtils.getBlock((IBlockAccess)this.field_145850_b, this.field_174879_c)).setLaser(((TileEntityLaserBlock)this.field_145850_b.func_175625_s(this.field_174879_c)).getOwner(), this.field_145850_b, this.field_174879_c);
        } else {
            BlockLaserBlock.destroyAdjacentLasers(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
        if (action == EnumLinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.OptionBoolean)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_REMOVED) {
            EnumModuleType module = (EnumModuleType)((Object)parameters[1]);
            this.removeModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.HARMING, EnumModuleType.WHITELIST, EnumModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

