/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedButton;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedLever;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedPressurePlate;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUtils {
    private static final List<Block> PRESSURE_PLATES = Arrays.asList(SCContent.reinforcedStonePressurePlate, SCContent.reinforcedWoodenPressurePlate);
    private static final List<Block> BUTTONS = Arrays.asList(SCContent.reinforcedStoneButton, SCContent.reinforcedWoodenButton);

    public static void updateAndNotify(World world, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.func_175684_a(pos, block, delay);
        }
        world.func_175685_c(pos, block, false);
    }

    public static int getBlockMeta(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
    }

    public static Block getBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_180495_p(BlockUtils.toPos(x, y, z)).func_177230_c();
    }

    public static void setBlockProperty(World world, BlockPos pos, PropertyBool property, boolean value) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177228_b().containsKey((Object)property)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)property, (Comparable)Boolean.valueOf(value)));
        }
    }

    public static void setBlockProperty(World world, BlockPos pos, PropertyInteger property, int value) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177228_b().containsKey((Object)property)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)property, (Comparable)Integer.valueOf(value)));
        }
    }

    public static void setFacingProperty(World world, BlockPos pos, PropertyEnum<EnumFacing> property, EnumFacing value) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177228_b().containsKey(property)) {
            world.func_175656_a(pos, state.func_177226_a(property, (Comparable)value));
        }
    }

    public static boolean hasBlockProperty(World world, BlockPos pos, IProperty<?> property) {
        try {
            world.func_180495_p(pos).func_177229_b(property);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static <T extends Comparable<T>> T getBlockProperty(IBlockAccess world, BlockPos pos, IProperty<T> property) {
        return (T)world.func_180495_p(pos).func_177229_b(property);
    }

    public static AxisAlignedBB fromBounds(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d6 = Math.min(x1, x2);
        double d7 = Math.min(y1, y2);
        double d8 = Math.min(z1, z2);
        double d9 = Math.max(x1, x2);
        double d10 = Math.max(y1, y2);
        double d11 = Math.max(z1, z2);
        return new AxisAlignedBB(d6, d7, d8, d9, d10, d11);
    }

    public static BlockPos toPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static int[] fromPos(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static boolean hasActiveSCBlockNextTo(World world, BlockPos pos) {
        TileEntity thisTile = world.func_175625_s(pos);
        return BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, SCContent.laserBlock, true, (state, te) -> (Boolean)state.func_177229_b((IProperty)BlockLaserBlock.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, SCContent.retinalScanner, true, (state, te) -> (Boolean)state.func_177229_b((IProperty)BlockRetinalScanner.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, SCContent.keypad, true, (state, te) -> (Boolean)state.func_177229_b((IProperty)BlockKeypad.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, SCContent.keycardReader, true, (state, te) -> (Boolean)state.func_177229_b((IProperty)BlockKeycardReader.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, SCContent.inventoryScanner, true, (state, te) -> ((TileEntityInventoryScanner)te).hasModule(EnumModuleType.REDSTONE) && ((TileEntityInventoryScanner)te).shouldProvidePower()) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, null, false, (state, te) -> PRESSURE_PLATES.contains(state.func_177230_c()) && (Boolean)state.func_177229_b((IProperty)BlockReinforcedPressurePlate.field_176580_a) != false) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, null, false, (state, te) -> BUTTONS.contains(state.func_177230_c()) && (Boolean)state.func_177229_b((IProperty)BlockReinforcedButton.field_176584_b) != false) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, SCContent.reinforcedLever, true, (state, te) -> (Boolean)state.func_177229_b((IProperty)BlockReinforcedLever.field_176359_b));
    }

    private static boolean hasActiveSCBlockNextTo(World world, BlockPos pos, TileEntity te, Block block, boolean checkForBlock, BiFunction<IBlockState, TileEntity, Boolean> extraCondition) {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity offsetTe;
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            if ((!checkForBlock || offsetState.func_177230_c() == block) && extraCondition.apply(offsetState, offsetTe = world.func_175625_s(offsetPos)).booleanValue()) {
                return ((IOwnable)offsetTe).getOwner().owns((IOwnable)te);
            }
            if (world.func_175651_c(offsetPos, facing) != 15 || offsetState.func_185897_m()) continue;
            for (EnumFacing dirOffset : EnumFacing.values()) {
                if (dirOffset.func_176734_d() == facing) continue;
                BlockPos newOffsetPos = offsetPos.func_177972_a(dirOffset);
                offsetState = world.func_180495_p(newOffsetPos);
                if (checkForBlock && offsetState.func_177230_c() != block) continue;
                if (offsetState.func_177227_a().contains(BlockLever.field_176360_a) ? dirOffset != ((BlockLever.EnumOrientation)offsetState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() : offsetState.func_177227_a().contains(BlockDirectional.field_176387_N) && dirOffset != offsetState.func_177229_b((IProperty)BlockDirectional.field_176387_N)) {
                    return false;
                }
                TileEntity offsetTe2 = world.func_175625_s(newOffsetPos);
                if (!extraCondition.apply(offsetState, offsetTe2).booleanValue()) continue;
                return ((IOwnable)offsetTe2).getOwner().owns((IOwnable)te);
            }
        }
        return false;
    }
}

