/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntitySecretSign;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ModuleUtils {
    public static List<String> getPlayersFromModule(World world, BlockPos pos, EnumModuleType module) {
        IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
        if (te.hasModule(module)) {
            return ModuleUtils.getPlayersFromModule(te.getModule(module));
        }
        return new ArrayList<String>();
    }

    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77973_b() instanceof ItemModule) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.func_77978_p() == null || stack.func_77978_p().func_74779_i("Player" + i) == null || stack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                list.add(stack.func_77978_p().func_74779_i("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean checkForModule(World world, BlockPos pos, EntityPlayer player, EnumModuleType module) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IModuleInventory)) {
            return false;
        }
        if (te instanceof TileEntityKeypad) {
            TileEntityKeypad keypad = (TileEntityKeypad)te;
            if (module == EnumModuleType.WHITELIST && keypad.hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
                if (keypad.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keypad), ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                return true;
            }
            if (module == EnumModuleType.BLACKLIST && keypad.hasModule(EnumModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.BLACKLIST).contains(player.func_70005_c_().toLowerCase())) {
                if (keypad.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keypad), ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof TileEntityKeypadChest) {
            TileEntityKeypadChest chest = (TileEntityKeypadChest)te;
            if (module == EnumModuleType.WHITELIST && ((IModuleInventory)te).hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
                if (chest.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keypadChest), ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                return true;
            }
            if (module == EnumModuleType.BLACKLIST && ((IModuleInventory)te).hasModule(EnumModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.BLACKLIST).contains(player.func_70005_c_().toLowerCase())) {
                if (chest.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keypadChest), ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof TileEntityKeypadFurnace) {
            TileEntityKeypadFurnace furnace = (TileEntityKeypadFurnace)te;
            if (module == EnumModuleType.WHITELIST && ((IModuleInventory)te).hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
                if (furnace.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keypadFurnace), ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                return true;
            }
            if (module == EnumModuleType.BLACKLIST && ((IModuleInventory)te).hasModule(EnumModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.BLACKLIST).contains(player.func_70005_c_().toLowerCase())) {
                if (furnace.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keypadFurnace), ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof TileEntityKeycardReader) {
            TileEntityKeycardReader reader = (TileEntityKeycardReader)te;
            if (module == EnumModuleType.WHITELIST && reader.hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
                if (reader.sendsMessages() && world.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keycardReader), ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c(), false);
                return true;
            }
            if (module == EnumModuleType.BLACKLIST && reader.hasModule(EnumModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.BLACKLIST).contains(player.func_70005_c_().toLowerCase())) {
                if (reader.sendsMessages() && world.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(player, ModuleUtils.translate(SCContent.keycardReader), ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof TileEntityRetinalScanner ? module == EnumModuleType.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase()) : (te instanceof TileEntityInventoryScanner ? module == EnumModuleType.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase()) : te instanceof TileEntitySecretSign && module == EnumModuleType.WHITELIST && ((TileEntitySecretSign)te).hasModule(EnumModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(player.func_70005_c_().toLowerCase()))) {
            return true;
        }
        return false;
    }

    public static void createLinkedAction(EnumLinkedAction action, ItemStack stack, CustomizableSCTE te) {
        if (action == EnumLinkedAction.MODULE_INSERTED) {
            te.createLinkedBlockAction(action, new Object[]{stack, (ItemModule)stack.func_77973_b()}, te);
        } else if (action == EnumLinkedAction.MODULE_REMOVED) {
            te.createLinkedBlockAction(action, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModuleType()}, te);
        }
        if (te instanceof TileEntitySecurityCamera) {
            te.func_145831_w().func_175685_c(te.func_174877_v().func_177967_a((EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), te.func_145838_q(), false);
        }
    }

    private static String translate(Block block) {
        return ClientUtils.localize(block.func_149739_a() + ".name", new Object[0]);
    }
}

