/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.block;

import calemiutils.block.base.BlockColoredBase;
import calemiutils.config.CUConfig;
import calemiutils.init.InitBlocks;
import calemiutils.item.ItemBuildersKit;
import calemiutils.util.Location;
import calemiutils.util.MaterialSound;
import calemiutils.util.UnitChatMessage;
import calemiutils.util.VeinScan;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.SoundHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBlueprint
extends BlockColoredBase {
    public BlockBlueprint() {
        super("blueprint", MaterialSound.STONE, 0.1f, 0, 0.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COLOR, (Comparable)EnumDyeColor.BLUE));
    }

    public IBlockState getStateByPrefix(String prefix) {
        EnumDyeColor dye = EnumDyeColor.BLUE;
        for (EnumDyeColor dyes : EnumDyeColor.values()) {
            if (!dyes.func_176610_l().startsWith(prefix)) continue;
            dye = dyes;
        }
        return this.func_176203_a(dye.func_176765_a());
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        Location location = new Location(world, pos);
        ItemStack currentStack = player.func_184614_ca();
        UnitChatMessage message = new UnitChatMessage("Blueprint", player);
        VeinScan scan = new VeinScan(location, location.getBlockState());
        scan.startScan();
        if (!currentStack.func_190926_b() && currentStack.func_77973_b() != Item.func_150898_a((Block)this)) {
            if (currentStack.func_77973_b() instanceof ItemBlock) {
                this.replaceAllBlocks(world, player, location, currentStack, scan, message);
            } else if (currentStack.func_77973_b() instanceof ItemBuildersKit) {
                this.replaceAllBlocks(world, player, location, ((ItemBuildersKit)currentStack.func_77973_b()).getBlockType(currentStack), scan, message);
            }
        } else if (!world.field_72995_K && player.func_70093_af() && currentStack.func_190926_b()) {
            if (scan.buffer.size() >= CUConfig.blockScans.veinScanMaxSize) {
                message.printMessage(TextFormatting.GREEN, "There are " + CUConfig.blockScans.veinScanMaxSize + "+ connected Blueprints");
            } else {
                message.printMessage(TextFormatting.GREEN, "There are " + ItemHelper.countByStacks(scan.buffer.size()) + " connected Blueprints");
            }
        }
    }

    private void replaceAllBlocks(World world, EntityPlayer player, Location location, ItemStack currentStack, VeinScan scan, UnitChatMessage message) {
        IBlockState state = Block.func_149634_a((Item)currentStack.func_77973_b()).getStateForPlacement(player.field_70170_p, location.getBlockPos(), EnumFacing.UP, 0.0f, 0.0f, 0.0f, currentStack.func_77952_i(), (EntityLivingBase)player, EnumHand.MAIN_HAND);
        if (this.canPlaceBlockInBlueprint(state)) {
            if (player.func_70093_af()) {
                this.replaceBlock(location, player, state);
                InventoryHelper.consumeItem((IInventory)player.field_71071_by, 1, true, currentStack);
                SoundHelper.playBlockPlaceSound(world, player, Block.func_149634_a((Item)currentStack.func_77973_b()).func_176223_P(), location);
            } else {
                int itemCount = InventoryHelper.countItems((IInventory)player.field_71071_by, true, false, currentStack);
                if (itemCount >= scan.buffer.size()) {
                    int amountToConsume = 0;
                    for (Location nextLocation : scan.buffer) {
                        ++amountToConsume;
                        this.replaceBlock(nextLocation, player, state);
                    }
                    if (amountToConsume > 0) {
                        SoundHelper.playDing(player.field_70170_p, player);
                        SoundHelper.playBlockPlaceSound(world, player, Block.func_149634_a((Item)currentStack.func_77973_b()).func_176223_P(), location);
                        if (!world.field_72995_K) {
                            message.printMessage(TextFormatting.GREEN, "Placed " + ItemHelper.countByStacks(amountToConsume));
                        }
                        InventoryHelper.consumeItem((IInventory)player.field_71071_by, amountToConsume, true, currentStack);
                    }
                } else if (!world.field_72995_K) {
                    message.printMessage(TextFormatting.RED, "You don't have enough blocks of that type!");
                    message.printMessage(TextFormatting.RED, "You're missing: " + ItemHelper.countByStacks(scan.buffer.size() - itemCount));
                }
            }
        }
    }

    private void replaceBlock(Location location, EntityPlayer player, IBlockState state) {
        if (!player.field_70170_p.field_72995_K) {
            location.setBlock(state, player);
            ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)BlockSnapshot.getBlockSnapshot((World)player.field_70170_p, (BlockPos)location.getBlockPos()), (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND);
        }
    }

    private boolean canPlaceBlockInBlueprint(IBlockState state) {
        if (state.func_177230_c() instanceof BlockChest) {
            return false;
        }
        return state.func_185904_a() != Material.field_151585_k && state.func_185904_a() != Material.field_151579_a && state.func_185904_a() != Material.field_151574_g && state.func_185904_a() != Material.field_151570_A && state.func_185904_a() != Material.field_151568_F && state.func_185904_a() != Material.field_151593_r && state.func_185904_a() != Material.field_151594_q && state.func_185904_a() != Material.field_151582_l && state.func_185904_a() != Material.field_151567_E;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() instanceof BlockBlueprint) {
            return ((EnumDyeColor)state.func_177229_b((IProperty)COLOR)).func_176765_a();
        }
        return 0;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (CUConfig.misc.blueprintPassable) {
            return field_185506_k;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (this == InitBlocks.BLUEPRINT) {
            if (blockState != iblockstate) {
                return true;
            }
            if (block == this) {
                return false;
            }
        }
        return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

