/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.block;

import calemiutils.CalemiUtils;
import calemiutils.block.base.BlockInventoryContainerBase;
import calemiutils.config.CUConfig;
import calemiutils.item.ItemLinkBookLocation;
import calemiutils.tileentity.TileEntityBookStand;
import calemiutils.util.IExtraInformation;
import calemiutils.util.Location;
import calemiutils.util.MaterialSound;
import calemiutils.util.helper.LoreHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBookStand
extends BlockInventoryContainerBase
implements IExtraInformation {
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyBool BOOK = PropertyBool.func_177716_a((String)"book");
    private static final float pixel = 0.0625f;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);

    public BlockBookStand() {
        super("book_stand", MaterialSound.WOOD, 1.0f, 0, 1.0f);
        this.func_149647_a(CalemiUtils.TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BOOK, (Comparable)Boolean.FALSE));
        if (CUConfig.blockUtils.bookStand && CUConfig.itemUtils.locationLinkBook) {
            this.addBlock();
        }
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Holds Link Books.");
        LoreHelper.addControlsLore(tooltip, "Open Gui", LoreHelper.Type.USE, true);
        LoreHelper.addControlsLore(tooltip, "Open Inventory", LoreHelper.Type.SNEAK_USE);
        LoreHelper.addControlsLore(tooltip, "Place Book (Copies data from stored book if it exists)", LoreHelper.Type.USE_BOOK);
    }

    @Override
    public void getButtonInformation(List<String> list, World world, Location location, ItemStack stack) {
        ItemLinkBookLocation book = this.getBook(world, location.getBlockPos());
        ItemStack bookStack = this.getBookStack(world, location.getBlockPos());
        if (book != null && bookStack != null && book.isLinked(bookStack)) {
            list.add("Book: " + bookStack.func_82833_r());
            list.add("Book Location: " + ItemLinkBookLocation.getLinkedLocation(world, bookStack));
        }
    }

    @Override
    public ItemStack getButtonIcon(World world, Location location, ItemStack stack) {
        return stack;
    }

    private ItemStack getBookStack(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBookStand) {
            TileEntityBookStand bookStand = (TileEntityBookStand)tileEntity;
            return bookStand.func_70301_a(0);
        }
        return null;
    }

    private ItemLinkBookLocation getBook(World world, BlockPos pos) {
        ItemStack stack;
        if (this.getBookStack(world, pos) != null && (stack = this.getBookStack(world, pos)) != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemLinkBookLocation) {
            return (ItemLinkBookLocation)stack.func_77973_b();
        }
        return null;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemLinkBookLocation book = this.getBook(worldIn, pos);
        if (hand != null && !playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() instanceof ItemLinkBookLocation) {
            return false;
        }
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)CalemiUtils.instance, (int)0, (World)worldIn, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
                return true;
            }
        } else if (book != null) {
            if (worldIn.field_72995_K) {
                book.openGui(playerIn, this.getBookStack(worldIn, pos));
            }
            return true;
        }
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockBookStand.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState blockState = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState blockState1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState blockState2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState blockState3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH && blockState.func_185913_b() && !blockState1.func_185913_b()) {
                face = EnumFacing.SOUTH;
            } else if (face == EnumFacing.SOUTH && blockState1.func_185913_b() && !blockState.func_185913_b()) {
                face = EnumFacing.NORTH;
            } else if (face == EnumFacing.WEST && blockState2.func_185913_b() && !blockState3.func_185913_b()) {
                face = EnumFacing.EAST;
            } else if (face == EnumFacing.EAST && blockState3.func_185913_b() && !blockState2.func_185913_b()) {
                face = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)face), 2);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BOOK});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBookStand();
    }
}

