/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.block;

import calemiutils.CalemiUtils;
import calemiutils.block.base.BlockInventoryContainerBase;
import calemiutils.config.CUConfig;
import calemiutils.tileentity.TileEntityInteractionInterface;
import calemiutils.util.HardnessConstants;
import calemiutils.util.Location;
import calemiutils.util.MaterialSound;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.SecurityHelper;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockInteractionInterface
extends BlockInventoryContainerBase {
    public BlockInteractionInterface() {
        super("interaction_interface", MaterialSound.IRON, HardnessConstants.SECURED);
        this.func_149647_a(CalemiUtils.TAB);
        if (CUConfig.blockUtils.interactionNetwork) {
            this.addBlock();
        }
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        LoreHelper.addInformationLore(tooltip, "Place a block on top of it and connect it to an Interaction Terminal to function.");
        LoreHelper.addControlsLore(tooltip, "Open Inventory", LoreHelper.Type.USE, true);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Location location = new Location(worldIn, pos);
        if (hand == EnumHand.MAIN_HAND && SecurityHelper.openSecuredBlock(location, playerIn, true)) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityInteractionInterface();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

