/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.block;

import calemiutils.block.BlockNetworkCableOpaque;
import calemiutils.tileentity.base.INetwork;
import calemiutils.util.helper.AABBHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNetworkCable
extends BlockNetworkCableOpaque {
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool DOWNUP = PropertyBool.func_177716_a((String)"downup");
    private static final PropertyBool NORTHSOUTH = PropertyBool.func_177716_a((String)"northsouth");
    private static final PropertyBool EASTWEST = PropertyBool.func_177716_a((String)"eastwest");
    private static final float pixel = 0.0625f;
    private static final AxisAlignedBB CORE_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.3125);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB DOWNUP_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB NORTHSOUTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0);
    private static final AxisAlignedBB EASTWEST_AABB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);

    public BlockNetworkCable() {
        super("network_cable", true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DOWN, (Comparable)Boolean.FALSE).func_177226_a((IProperty)UP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)WEST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)DOWNUP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NORTHSOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)EASTWEST, (Comparable)Boolean.FALSE));
    }

    private static AxisAlignedBB getBoundingBoxIdx(IBlockState state) {
        AxisAlignedBB i = CORE_AABB;
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            i = AABBHelper.addTwoBoundingBoxes(i, DOWN_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            i = AABBHelper.addTwoBoundingBoxes(i, UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i = AABBHelper.addTwoBoundingBoxes(i, NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i = AABBHelper.addTwoBoundingBoxes(i, EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i = AABBHelper.addTwoBoundingBoxes(i, SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i = AABBHelper.addTwoBoundingBoxes(i, WEST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWNUP)).booleanValue()) {
            i = DOWNUP_AABB;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTHSOUTH)).booleanValue()) {
            i = NORTHSOUTH_AABB;
        }
        if (((Boolean)state.func_177229_b((IProperty)EASTWEST)).booleanValue()) {
            i = EASTWEST_AABB;
        }
        return i;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CORE_AABB);
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWNUP)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWNUP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTHSOUTH)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTHSOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EASTWEST)).booleanValue()) {
            BlockNetworkCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EASTWEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BlockNetworkCable.getBoundingBoxIdx(state);
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof INetwork) {
            INetwork network = (INetwork)tileEntity;
            for (EnumFacing dir : network.getConnectedDirections()) {
                if (facing != dir) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectTo(world, pos.func_177972_a(facing), facing.func_176734_d());
    }

    private boolean canCableConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, facing.func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean eastwest;
        boolean down = this.canCableConnectTo(worldIn, pos, EnumFacing.DOWN);
        boolean up = this.canCableConnectTo(worldIn, pos, EnumFacing.UP);
        boolean north = this.canCableConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean east = this.canCableConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean south = this.canCableConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean west = this.canCableConnectTo(worldIn, pos, EnumFacing.WEST);
        boolean downup = down && up && !north && !east && !south && !west;
        boolean northsouth = north && south && !down && !up && !east && !west;
        boolean bl = eastwest = east && west && !north && !south && !down && !up;
        if (downup || northsouth || eastwest) {
            down = false;
            up = false;
            north = false;
            east = false;
            south = false;
            west = false;
        }
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(up)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)DOWNUP, (Comparable)Boolean.valueOf(downup)).func_177226_a((IProperty)NORTHSOUTH, (Comparable)Boolean.valueOf(northsouth)).func_177226_a((IProperty)EASTWEST, (Comparable)Boolean.valueOf(eastwest));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, EAST, WEST, SOUTH, DOWNUP, NORTHSOUTH, EASTWEST});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }
}

